/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.cassandra.column;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.cassandra.column.CassandraRepositoryAsync;
import org.jnosql.artemis.cassandra.column.CassandraRepositoryAsyncProxy;
import org.jnosql.artemis.cassandra.column.CassandraTemplateAsync;
import org.jnosql.artemis.column.ColumnRepositoryAsyncProducer;
import org.jnosql.artemis.column.ColumnTemplateAsync;
import org.jnosql.artemis.spi.AbstractBean;

class CassandraRepositoryAsyncBean
extends AbstractBean<CassandraRepositoryAsync> {
    private final Class type;
    private final Set<Type> types;
    private final Set<Annotation> qualifiers = Collections.singleton(new AnnotationLiteral<Default>(){});

    CassandraRepositoryAsyncBean(Class type, BeanManager beanManager) {
        super(beanManager);
        this.type = type;
        this.types = Collections.singleton(type);
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public CassandraRepositoryAsync create(CreationalContext<CassandraRepositoryAsync> creationalContext) {
        CassandraTemplateAsync templateAsync = (CassandraTemplateAsync)this.getInstance(CassandraTemplateAsync.class);
        ColumnRepositoryAsyncProducer producer = (ColumnRepositoryAsyncProducer)this.getInstance(ColumnRepositoryAsyncProducer.class);
        RepositoryAsync repositoryAsync = producer.get(this.type, (ColumnTemplateAsync)templateAsync);
        CassandraRepositoryAsyncProxy handler = new CassandraRepositoryAsyncProxy(templateAsync, repositoryAsync);
        return (CassandraRepositoryAsync)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, handler);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return this.type.getName() + "Async@cassandra";
    }
}

