/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.cassandra.column;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jnosql.artemis.cassandra.column.CassandraRepository;
import org.jnosql.artemis.cassandra.column.CassandraRepositoryAsync;
import org.jnosql.artemis.cassandra.column.CassandraRepositoryAsyncBean;
import org.jnosql.artemis.cassandra.column.CassandraRepositoryBean;

public class CassandraExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(CassandraExtension.class.getName());
    private final Collection<Class<?>> crudTypes = new HashSet();
    private final Collection<Class<?>> crudAsyncTypes = new HashSet();

    <T extends CassandraRepository> void onProcessAnnotatedType(@Observes ProcessAnnotatedType<T> repo) {
        Class javaClass = repo.getAnnotatedType().getJavaClass();
        if (CassandraRepository.class.equals((Object)javaClass)) {
            return;
        }
        if (Stream.of(javaClass.getInterfaces()).anyMatch(CassandraRepository.class::equals) && Modifier.isInterface(javaClass.getModifiers())) {
            this.crudTypes.add(javaClass);
        }
    }

    <T extends CassandraRepositoryAsync> void onProcessAnnotatedTypeAsync(@Observes ProcessAnnotatedType<T> repo) {
        Class javaClass = repo.getAnnotatedType().getJavaClass();
        if (CassandraRepositoryAsync.class.equals((Object)javaClass)) {
            return;
        }
        if (Stream.of(javaClass.getInterfaces()).anyMatch(CassandraRepositoryAsync.class::equals) && Modifier.isInterface(javaClass.getModifiers())) {
            this.crudAsyncTypes.add(javaClass);
        }
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        LOGGER.info("Starting the onAfterBeanDiscovery with elements number: " + this.crudTypes.size());
        this.crudTypes.forEach(type -> afterBeanDiscovery.addBean((Bean)new CassandraRepositoryBean((Class)type, beanManager)));
        this.crudAsyncTypes.forEach(type -> afterBeanDiscovery.addBean((Bean)new CassandraRepositoryAsyncBean((Class)type, beanManager)));
        LOGGER.info("Finished the onAfterBeanDiscovery");
    }
}

