/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.cassandra.column;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.cassandra.column.CassandraUDTType;
import org.jnosql.artemis.cassandra.column.UDT;
import org.jnosql.artemis.column.AbstractColumnEntityConverter;
import org.jnosql.artemis.column.ColumnEntityConverter;
import org.jnosql.artemis.column.ColumnFieldValue;
import org.jnosql.artemis.reflection.ClassMappings;
import org.jnosql.artemis.reflection.FieldMapping;
import org.jnosql.artemis.reflection.GenericFieldMapping;
import org.jnosql.diana.api.column.Column;

@ApplicationScoped
@Typed(value={CassandraColumnEntityConverter.class})
class CassandraColumnEntityConverter
extends AbstractColumnEntityConverter
implements ColumnEntityConverter {
    @Inject
    private ClassMappings mappings;
    @Inject
    private Converters converters;

    CassandraColumnEntityConverter() {
    }

    protected ClassMappings getClassMappings() {
        return this.mappings;
    }

    protected Converters getConverters() {
        return this.converters;
    }

    protected <T> Consumer<String> feedObject(T instance, List<Column> columns, Map<String, FieldMapping> fieldsGroupByName) {
        return k -> {
            FieldMapping field = (FieldMapping)fieldsGroupByName.get(k);
            if (Objects.nonNull(field.getNativeField().getAnnotation(UDT.class))) {
                Optional<Column> column = columns.stream().filter(c -> c.getName().equals(k)).findFirst();
                this.setUDTField(instance, column, field);
            } else {
                super.feedObject(instance, columns, fieldsGroupByName).accept(k);
            }
        };
    }

    private <T> void setUDTField(T instance, Optional<Column> column, FieldMapping field) {
        if (column.isPresent() && org.jnosql.diana.cassandra.column.UDT.class.isInstance(column.get())) {
            org.jnosql.diana.cassandra.column.UDT udt = (org.jnosql.diana.cassandra.column.UDT)org.jnosql.diana.cassandra.column.UDT.class.cast(column.get());
            Object columns = udt.get();
            if (StreamSupport.stream(((Iterable)Iterable.class.cast(columns)).spliterator(), false).allMatch(Iterable.class::isInstance)) {
                GenericFieldMapping genericField = (GenericFieldMapping)GenericFieldMapping.class.cast(field);
                Collection collection = genericField.getCollectionInstance();
                List embeddable = (List)columns;
                for (List columnList : embeddable) {
                    Object element = this.toEntity(genericField.getElementType(), columnList);
                    collection.add(element);
                }
                field.write(instance, (Object)collection);
            } else {
                Object value = this.toEntity(field.getNativeField().getType(), (List)columns);
                field.write(instance, value);
            }
        }
    }

    protected ColumnFieldValue to(FieldMapping field, Object entityInstance) {
        Object value = field.read(entityInstance);
        UDT annotation = field.getNativeField().getAnnotation(UDT.class);
        if (Objects.isNull(annotation)) {
            return super.to(field, entityInstance);
        }
        return new CassandraUDTType(annotation.value(), value, field);
    }
}

