/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.CollectionElement;
import org.jibx.binding.model.ContainerElementBase;
import org.jibx.binding.model.IComponent;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.ModelVisitor;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.binding.model.StructureElement;
import org.jibx.binding.model.StructureElementBase;
import org.jibx.binding.model.TemplateElementBase;
import org.jibx.binding.model.ValidationContext;
import org.jibx.binding.model.ValueElement;
import org.jibx.custom.classes.ClassCustom;
import org.jibx.custom.classes.GlobalCustom;
import org.jibx.runtime.QName;
import org.jibx.schema.generator.EnumDetail;
import org.jibx.schema.generator.MappingDetail;
import org.jibx.util.IClass;
import org.jibx.util.Types;

public class DetailDirectory {
    private final GlobalCustom m_custom;
    private final ValidationContext m_context;
    private final Map m_mappingMap;
    private final Map m_enumMap;
    private final Set m_forceTypeMappings;

    public DetailDirectory(GlobalCustom custom, ValidationContext vctx) {
        this.m_custom = custom;
        this.m_context = vctx;
        this.m_mappingMap = new HashMap();
        this.m_enumMap = new HashMap();
        this.m_forceTypeMappings = new HashSet();
    }

    public void populate(List bindings) {
        AnalysisVisitor visitor = new AnalysisVisitor(this.m_context);
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            this.m_context.tourTree((BindingElement)iter.next(), (ModelVisitor)visitor);
        }
        for (MappingElement mapping : this.m_forceTypeMappings) {
            MappingDetail detail = (MappingDetail)this.m_mappingMap.get(mapping);
            detail.setType(true);
        }
    }

    private static boolean isTypeDerivation(StructureElement struct) {
        return struct.children().size() == 0 && !struct.hasName() && !struct.hasProperty() && !struct.isOptional() && (struct.getDeclaredType() != null || struct.getEffectiveMapping() != null);
    }

    private boolean isEnumeration(IClass clas) {
        return clas.isSuperclass("java.lang.Enum");
    }

    private boolean isSimpleValue(IClass clas) {
        return Types.isSimpleValue((String)clas.getName());
    }

    private void countEnumUsage(String type) {
        EnumDetail detail = (EnumDetail)this.m_enumMap.get(type);
        if (detail == null) {
            ClassCustom custom = this.m_custom.addClassCustomization(type);
            detail = new EnumDetail(custom);
            this.m_enumMap.put(type, detail);
            if (custom.isForceMapping()) {
                detail.setGlobal(true);
            }
        } else {
            detail.setGlobal(true);
        }
    }

    private void checkReferences(ContainerElementBase cont, ContainerElementBase base) {
        ArrayList childs = cont.children();
        for (int i = 0; i < childs.size(); ++i) {
            Object child = childs.get(i);
            if (child == base) continue;
            if (child instanceof ValueElement) {
                IClass type = ((ValueElement)child).getType();
                if (!this.isEnumeration(type)) continue;
                this.countEnumUsage(type.getName());
                continue;
            }
            if (child instanceof CollectionElement) {
                CollectionElement collect = (CollectionElement)child;
                IClass itype = collect.getItemTypeClass();
                if (this.isEnumeration(itype)) {
                    this.countEnumUsage(itype.getName());
                } else if (!this.isSimpleValue(itype)) {
                    String type = itype.getName();
                    TemplateElementBase ref = collect.getDefinitions().getSpecificTemplate(type);
                    if (ref instanceof MappingElement) {
                        MappingElement mapref = (MappingElement)ref;
                        MappingDetail detail = this.forceMappingDetail(mapref);
                        detail.setElement(true);
                    }
                }
                this.checkReferences((ContainerElementBase)collect, null);
                continue;
            }
            if (!(child instanceof StructureElement)) continue;
            StructureElement struct = (StructureElement)child;
            if (struct.children().size() > 0) {
                this.checkReferences((ContainerElementBase)struct, null);
                continue;
            }
            MappingElement ref = (MappingElement)struct.getEffectiveMapping();
            if (ref == null) {
                this.m_context.addError("No handling defined for empty structure with no mapping reference", (Object)struct);
                continue;
            }
            MappingDetail detail = this.forceMappingDetail(ref);
            if (struct.hasDirectName()) {
                if (ref.isAbstract()) {
                    detail.setType(true);
                    continue;
                }
                this.m_context.addError("No handling defined for name on concrete mapping reference", (Object)struct);
                continue;
            }
            if (ref.getName() == null) {
                detail.setGroup(true);
                continue;
            }
            detail.setElement(true);
        }
    }

    private MappingDetail addDetail(MappingElement map) {
        MappingElement extended;
        StructureElement struct;
        Object content;
        MappingElement base = null;
        StructureElement baseref = null;
        ArrayList contents = map.getContentComponents();
        if (contents.size() > 0 && (content = contents.get(0)) instanceof StructureElement && DetailDirectory.isTypeDerivation(struct = (StructureElement)content)) {
            base = (MappingElement)struct.getEffectiveMapping();
            baseref = struct;
        }
        boolean haschild = false;
        boolean hastext = false;
        ArrayList<Object> expands = new ArrayList<Object>();
        expands.add(map);
        for (int i = 0; i < expands.size(); ++i) {
            ContainerElementBase contain = (ContainerElementBase)expands.get(i);
            contents = contain.getContentComponents();
            for (int j = 0; j < contents.size(); ++j) {
                IComponent comp = (IComponent)contents.get(j);
                if (comp.hasName()) {
                    haschild = true;
                    continue;
                }
                if (comp instanceof ValueElement) {
                    hastext = true;
                    continue;
                }
                if (comp instanceof CollectionElement) {
                    haschild = true;
                    continue;
                }
                StructureElement struct2 = (StructureElement)comp;
                if (struct2.children().size() > 0) {
                    expands.add(comp);
                    continue;
                }
                MappingElementBase ref = (MappingElementBase)struct2.getEffectiveMapping();
                if (ref == null) continue;
                if (ref.getName() != null) {
                    haschild = true;
                    continue;
                }
                expands.add(ref);
                this.m_forceTypeMappings.add(ref);
            }
        }
        ClassCustom custom = this.m_custom.addClassCustomization(map.getClassName());
        QName tname = map.getTypeQName();
        if (tname == null) {
            NamespaceElement dfltns = map.getDefinitions().getElementDefaultNamespace();
            tname = dfltns != null ? new QName(dfltns.getUri(), custom.getTypeQName().getName()) : custom.getTypeQName();
        }
        QName oname = null;
        String name = map.getName();
        oname = name == null ? custom.getElementQName() : new QName(map.getNamespace().getUri(), name);
        MappingDetail detail = new MappingDetail((MappingElementBase)map, haschild, hastext, base, tname, oname);
        this.m_mappingMap.put(map, detail);
        if (map.getName() == null) {
            if (base != null) {
                MappingDetail basedetail = this.forceMappingDetail(base);
                basedetail.setType(true);
            }
        } else {
            detail.setElement(true);
        }
        if ((extended = map.getExtendsMapping()) != null) {
            boolean isext = false;
            MappingElement ancest = base;
            while (ancest != null) {
                if (ancest.getClassName().equals(extended.getClassName())) {
                    isext = true;
                    break;
                }
                ancest = this.forceMappingDetail(ancest).getExtensionBase();
            }
            if (isext) {
                MappingDetail extdetail = this.forceMappingDetail(extended);
                extdetail.setElement(true);
                detail.setSubstitution(extdetail.getOtherName());
                detail.setElement(true);
            } else {
                this.m_context.addError("'extends' mapping not usable as schema extension base", (Object)map);
            }
        }
        this.checkReferences((ContainerElementBase)map, (ContainerElementBase)baseref);
        return detail;
    }

    protected MappingDetail forceMappingDetail(MappingElement map) {
        MappingDetail detail = (MappingDetail)this.m_mappingMap.get(map);
        if (detail == null) {
            detail = this.addDetail(map);
        }
        return detail;
    }

    public MappingDetail getMappingDetail(MappingElementBase map) {
        MappingDetail detail = (MappingDetail)this.m_mappingMap.get(map);
        if (detail == null) {
            throw new IllegalStateException("Detail not found");
        }
        return detail;
    }

    public EnumDetail getSimpleDetail(String type) {
        EnumDetail detail = (EnumDetail)this.m_enumMap.get(type);
        if (detail == null) {
            throw new IllegalStateException("Detail not found");
        }
        return detail;
    }

    public Collection getComplexDetails() {
        return this.m_mappingMap.values();
    }

    public Collection getSimpleDetails() {
        return this.m_enumMap.values();
    }

    public class AnalysisVisitor
    extends ModelVisitor {
        private final ValidationContext m_context;

        public AnalysisVisitor(ValidationContext vctx) {
            this.m_context = vctx;
        }

        public boolean visit(MappingElement node) {
            if (!(this.m_context.getParentElement() instanceof BindingElement)) {
                this.m_context.addWarning("No schema equivalent for nested type definitions - converting to global type");
            }
            DetailDirectory.this.forceMappingDetail(node);
            return super.visit(node);
        }

        public boolean visit(StructureElementBase node) {
            return false;
        }
    }
}

