/*
 * Copyright (C) 2012 JFrog Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jfrog.build.extractor.clientConfiguration.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;

import java.io.IOException;
import java.io.StringWriter;

import static org.jfrog.build.extractor.BuildInfoExtractorUtils.createMapper;

/**
 * @author jbaruch
 * @since 15/02/12
 */
public class JsonSerializer<T> {

    public String toJSON(T object) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper mapper = createMapper();

        mapper.setAnnotationIntrospector(new JacksonAnnotationIntrospector());
        jsonFactory.setCodec(mapper);
        try (StringWriter writer = new StringWriter();
             JsonGenerator jsonGenerator = jsonFactory.createGenerator(writer)) {
            jsonGenerator.useDefaultPrettyPrinter();
            jsonGenerator.writeObject(object);

            return writer.getBuffer().toString();
        }
    }
}
