/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.zip;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.ZipException;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.datasource.DataSource;
import org.jetbrains.zip.signer.metadata.ZipMetadata;
import org.jetbrains.zip.signer.utils.ByteBufferExtensionsKt;
import org.jetbrains.zip.signer.zip.ZipSections;
import org.jetbrains.zip.signer.zip.ZipSectionsInformation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0001)B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J3\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0004J\u0012\u0010 \u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\rH\u0002J%\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b'\u0010(R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006*"}, d2={"Lorg/jetbrains/zip/signer/zip/ZipUtils;", "", "()V", "ZIP_EOCD_CENTRAL_DIR_OFFSET_FIELD_OFFSET", "", "ZIP_EOCD_CENTRAL_DIR_SIZE_FIELD_OFFSET", "ZIP_EOCD_COMMENT_LENGTH_FIELD_OFFSET", "ZIP_EOCD_REC_MIN_SIZE", "ZIP_EOCD_REC_SIG", "findEocdInBuffer", "Lkotlin/Pair;", "Lorg/jetbrains/zip/signer/zip/ZipUtils$ZipEocdData;", "zipContents", "Ljava/nio/ByteBuffer;", "", "zip", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "maxCommentSize", "Lkotlin/UShort;", "findEocdInBuffer-i8woANY", "(Lorg/jetbrains/zip/signer/datasource/DataSource;S)Lkotlin/Pair;", "findZipSections", "Lorg/jetbrains/zip/signer/zip/ZipSections;", "zipSectionsInformation", "Lorg/jetbrains/zip/signer/zip/ZipSectionsInformation;", "zipMetadata", "Lorg/jetbrains/zip/signer/metadata/ZipMetadata;", "findZipSections$lib", "findZipSectionsInformation", "getModifiedEocdRecord", "inputZipSections", "additionalMetadataSize", "parseEOCD", "eocdSection", "setZipEocdCentralDirectoryOffset", "", "zipEndOfCentralDirectory", "offset", "Lkotlin/UInt;", "setZipEocdCentralDirectoryOffset-Qn1smSk$lib", "(Ljava/nio/ByteBuffer;I)V", "ZipEocdData", "lib"})
@ExperimentalUnsignedTypes
public final class ZipUtils {
    @NotNull
    public static final ZipUtils INSTANCE = new ZipUtils();
    private static final int ZIP_EOCD_REC_MIN_SIZE = 22;
    private static final int ZIP_EOCD_REC_SIG = 101010256;
    private static final int ZIP_EOCD_CENTRAL_DIR_SIZE_FIELD_OFFSET = 12;
    private static final int ZIP_EOCD_CENTRAL_DIR_OFFSET_FIELD_OFFSET = 16;
    private static final int ZIP_EOCD_COMMENT_LENGTH_FIELD_OFFSET = 20;

    private ZipUtils() {
    }

    @NotNull
    public final ZipSectionsInformation findZipSectionsInformation(@NotNull DataSource zip) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        Pair<Long, ZipEocdData> pair = this.findEocdInBuffer(zip);
        if (pair == null) {
            throw new ZipException("ZIP End of Central Directory record not found");
        }
        Pair<Long, ZipEocdData> pair2 = pair;
        long eocdOffset = ((Number)pair2.component1()).longValue();
        ZipEocdData eocd = (ZipEocdData)pair2.component2();
        int n = eocd.getCentralDirectoryOffset-pVg5ArA();
        boolean bl = false;
        long l = (long)n & 0xFFFFFFFFL;
        n = eocd.getCentralDirectorySize-pVg5ArA();
        bl = false;
        long centralDirectoryEndOffset = l + ((long)n & 0xFFFFFFFFL);
        n = eocd.getCentralDirectoryOffset-pVg5ArA();
        bl = false;
        if (((long)n & 0xFFFFFFFFL) > eocdOffset) {
            throw new ZipException("ZIP Central Directory start offset out of range");
        }
        if (centralDirectoryEndOffset > eocdOffset) {
            throw new ZipException("ZIP Central Directory overlaps with End of Central Directory");
        }
        n = eocd.getCentralDirectoryOffset-pVg5ArA();
        bl = false;
        long l2 = (long)n & 0xFFFFFFFFL;
        n = eocd.getCentralDirectorySize-pVg5ArA();
        bl = false;
        return new ZipSectionsInformation(l2, (long)n & 0xFFFFFFFFL, eocdOffset, (int)(zip.size() - eocdOffset));
    }

    @NotNull
    public final ByteBuffer getModifiedEocdRecord(@NotNull ZipSections inputZipSections, int additionalMetadataSize) {
        Intrinsics.checkNotNullParameter((Object)inputZipSections, (String)"inputZipSections");
        ByteBuffer byteBuffer = inputZipSections.getEndOfCentralDirectorySection().getByteBuffer(0L, (int)inputZipSections.getEndOfCentralDirectorySection().size());
        boolean bl = false;
        boolean bl2 = false;
        ByteBuffer $this$getModifiedEocdRecord_u24lambda_u2d0 = byteBuffer;
        boolean bl3 = false;
        $this$getModifiedEocdRecord_u24lambda_u2d0.order(ByteOrder.LITTLE_ENDIAN);
        long l = inputZipSections.getBeforeSigningBlockSection().size() + (long)additionalMetadataSize;
        boolean bl4 = false;
        INSTANCE.setZipEocdCentralDirectoryOffset-Qn1smSk$lib($this$getModifiedEocdRecord_u24lambda_u2d0, UInt.constructor-impl((int)((int)l)));
        return byteBuffer;
    }

    @NotNull
    public final ZipSections findZipSections$lib(@NotNull DataSource zip, @NotNull ZipSectionsInformation zipSectionsInformation, @Nullable ZipMetadata zipMetadata) {
        long l;
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        Intrinsics.checkNotNullParameter((Object)zipSectionsInformation, (String)"zipSectionsInformation");
        long l2 = zipSectionsInformation.getCentralDirectoryOffset();
        ZipMetadata zipMetadata2 = zipMetadata;
        if (zipMetadata2 == null) {
            l = 0L;
        } else {
            long l3;
            int n = zipMetadata2.getSize();
            l = l3 = (long)n;
        }
        return new ZipSections(zip.slice(0L, l2 - l), zip.slice(zipSectionsInformation.getCentralDirectoryOffset(), zipSectionsInformation.getCentralDirectorySizeBytes()), zip.slice(zipSectionsInformation.getEndOfCentralDirectoryOffset(), zipSectionsInformation.getEndOfCentralDirectorySizeBytes()));
    }

    public final void setZipEocdCentralDirectoryOffset-Qn1smSk$lib(@NotNull ByteBuffer zipEndOfCentralDirectory, int offset) {
        Intrinsics.checkNotNullParameter((Object)zipEndOfCentralDirectory, (String)"zipEndOfCentralDirectory");
        boolean bl = ByteBufferExtensionsKt.isLittleEndian(zipEndOfCentralDirectory);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ByteBufferExtensionsKt.setUnsignedInt-jXDDuk8(zipEndOfCentralDirectory, zipEndOfCentralDirectory.position() + 16, offset);
    }

    private final Pair<Long, ZipEocdData> findEocdInBuffer(DataSource zip) {
        Pair<Long, ZipEocdData> pair = this.findEocdInBuffer-i8woANY(zip, (short)0);
        return pair == null ? this.findEocdInBuffer-i8woANY(zip, (short)-1) : pair;
    }

    private final Pair<Long, ZipEocdData> findEocdInBuffer-i8woANY(DataSource zip, short maxCommentSize) {
        long fileSize = zip.size();
        if (fileSize < 22L) {
            return null;
        }
        boolean bl = false;
        int maxEocdSize = 22 + RangesKt.coerceAtMost((int)(maxCommentSize & 0xFFFF), (int)((int)fileSize - 22));
        long bufOffsetInFile = fileSize - (long)maxEocdSize;
        Pair<Integer, ZipEocdData> pair = zip.getByteBuffer(bufOffsetInFile, maxEocdSize);
        boolean bl2 = false;
        boolean bl3 = false;
        Pair<Integer, ZipEocdData> $this$findEocdInBuffer_i8woANY_u24lambda_u2d1 = pair;
        boolean bl4 = false;
        $this$findEocdInBuffer_i8woANY_u24lambda_u2d1.order(ByteOrder.LITTLE_ENDIAN);
        Pair<Integer, ZipEocdData> buf = pair;
        Pair<Integer, ZipEocdData> pair2 = this.findEocdInBuffer((ByteBuffer)buf);
        if (pair2 == null) {
            return null;
        }
        pair = pair2;
        int eocdOffsetInBuffer = ((Number)pair.component1()).intValue();
        ZipEocdData eocd = (ZipEocdData)pair.component2();
        return TuplesKt.to((Object)(bufOffsetInFile + (long)eocdOffsetInBuffer), (Object)eocd);
    }

    private final Pair<Integer, ZipEocdData> findEocdInBuffer(ByteBuffer zipContents) {
        boolean bl = ByteBufferExtensionsKt.isLittleEndian(zipContents);
        int n = 0;
        int n2 = 0;
        n2 = 0;
        int n3 = 0;
        if (!bl) {
            boolean bl2 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int eocdWithEmptyCommentStartPosition = zipContents.capacity() - 22;
        if (eocdWithEmptyCommentStartPosition < 0) {
            return null;
        }
        n = 0;
        n3 = -1;
        boolean bl3 = false;
        n2 = RangesKt.coerceAtMost((int)eocdWithEmptyCommentStartPosition, (int)(n3 & 0xFFFF));
        if (n <= n2) {
            int possibleCommentLength;
            do {
                possibleCommentLength = n++;
                zipContents.position(eocdWithEmptyCommentStartPosition - possibleCommentLength);
                ZipEocdData zipEocdData = this.parseEOCD(zipContents);
                if (zipEocdData == null) continue;
                ZipEocdData zipEocd = zipEocdData;
                short s = zipEocd.getCommentLength-Mh2AYeg();
                boolean bl4 = false;
                if ((s & 0xFFFF) != possibleCommentLength) continue;
                return TuplesKt.to((Object)zipContents.position(), (Object)zipEocd);
            } while (possibleCommentLength != n2);
        }
        return null;
    }

    private final ZipEocdData parseEOCD(ByteBuffer eocdSection) {
        boolean bl = false;
        boolean bl2 = false;
        ByteBuffer $this$parseEOCD_u24lambda_u2d2 = eocdSection;
        boolean bl3 = false;
        boolean bl4 = ByteBufferExtensionsKt.isLittleEndian($this$parseEOCD_u24lambda_u2d2);
        boolean bl5 = false;
        boolean bl6 = false;
        bl6 = false;
        boolean bl7 = false;
        if (!bl4) {
            boolean bl8 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if ($this$parseEOCD_u24lambda_u2d2.getInt($this$parseEOCD_u24lambda_u2d2.position()) != 101010256) {
            return null;
        }
        return new ZipEocdData(ByteBufferExtensionsKt.getUnsignedInt($this$parseEOCD_u24lambda_u2d2, $this$parseEOCD_u24lambda_u2d2.position() + 16), ByteBufferExtensionsKt.getUnsignedInt($this$parseEOCD_u24lambda_u2d2, $this$parseEOCD_u24lambda_u2d2.position() + 12), ByteBufferExtensionsKt.getUnsignedShort($this$parseEOCD_u24lambda_u2d2, $this$parseEOCD_u24lambda_u2d2.position() + 20), null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B \u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\tJ\u0019\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\tJ\u0019\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\rJ4\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001c\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\tR\u001c\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/zip/signer/zip/ZipUtils$ZipEocdData;", "", "centralDirectoryOffset", "Lkotlin/UInt;", "centralDirectorySize", "commentLength", "Lkotlin/UShort;", "(IISLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCentralDirectoryOffset-pVg5ArA", "()I", "I", "getCentralDirectorySize-pVg5ArA", "getCommentLength-Mh2AYeg", "()S", "S", "component1", "component1-pVg5ArA", "component2", "component2-pVg5ArA", "component3", "component3-Mh2AYeg", "copy", "copy-EV3HgwY", "(IIS)Lorg/jetbrains/zip/signer/zip/ZipUtils$ZipEocdData;", "equals", "", "other", "hashCode", "", "toString", "", "lib"})
    private static final class ZipEocdData {
        private final int centralDirectoryOffset;
        private final int centralDirectorySize;
        private final short commentLength;

        private ZipEocdData(int centralDirectoryOffset, int centralDirectorySize, short commentLength) {
            this.centralDirectoryOffset = centralDirectoryOffset;
            this.centralDirectorySize = centralDirectorySize;
            this.commentLength = commentLength;
        }

        public final int getCentralDirectoryOffset-pVg5ArA() {
            return this.centralDirectoryOffset;
        }

        public final int getCentralDirectorySize-pVg5ArA() {
            return this.centralDirectorySize;
        }

        public final short getCommentLength-Mh2AYeg() {
            return this.commentLength;
        }

        public final int component1-pVg5ArA() {
            return this.centralDirectoryOffset;
        }

        public final int component2-pVg5ArA() {
            return this.centralDirectorySize;
        }

        public final short component3-Mh2AYeg() {
            return this.commentLength;
        }

        @NotNull
        public final ZipEocdData copy-EV3HgwY(int centralDirectoryOffset, int centralDirectorySize, short commentLength) {
            return new ZipEocdData(centralDirectoryOffset, centralDirectorySize, commentLength, null);
        }

        public static /* synthetic */ ZipEocdData copy-EV3HgwY$default(ZipEocdData zipEocdData, int n, int n2, short s, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = zipEocdData.centralDirectoryOffset;
            }
            if ((n3 & 2) != 0) {
                n2 = zipEocdData.centralDirectorySize;
            }
            if ((n3 & 4) != 0) {
                s = zipEocdData.commentLength;
            }
            return zipEocdData.copy-EV3HgwY(n, n2, s);
        }

        @NotNull
        public String toString() {
            return "ZipEocdData(centralDirectoryOffset=" + UInt.toString-impl((int)this.centralDirectoryOffset) + ", centralDirectorySize=" + UInt.toString-impl((int)this.centralDirectorySize) + ", commentLength=" + UShort.toString-impl((short)this.commentLength) + ')';
        }

        public int hashCode() {
            int result = UInt.hashCode-impl((int)this.centralDirectoryOffset);
            result = result * 31 + UInt.hashCode-impl((int)this.centralDirectorySize);
            result = result * 31 + UShort.hashCode-impl((short)this.commentLength);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ZipEocdData)) {
                return false;
            }
            ZipEocdData zipEocdData = (ZipEocdData)other;
            if (this.centralDirectoryOffset != zipEocdData.centralDirectoryOffset) {
                return false;
            }
            if (this.centralDirectorySize != zipEocdData.centralDirectorySize) {
                return false;
            }
            return this.commentLength == zipEocdData.commentLength;
        }

        public /* synthetic */ ZipEocdData(int centralDirectoryOffset, int centralDirectorySize, short commentLength, DefaultConstructorMarker $constructor_marker) {
            this(centralDirectoryOffset, centralDirectorySize, commentLength);
        }
    }
}

