/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.metadata;

import com.google.protobuf.ByteString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.proto.SignatureDataProto;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001f\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/zip/signer/metadata/SignatureData;", "", "protobufRepresentation", "Lorg/jetbrains/zip/signer/proto/SignatureDataProto;", "(Lorg/jetbrains/zip/signer/proto/SignatureDataProto;)V", "algorithm", "Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;", "signatureBytes", "", "(Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;[B)V", "(Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;[BLorg/jetbrains/zip/signer/proto/SignatureDataProto;)V", "getAlgorithm", "()Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;", "getProtobufRepresentation", "()Lorg/jetbrains/zip/signer/proto/SignatureDataProto;", "getSignatureBytes", "()[B", "lib"})
public final class SignatureData {
    @NotNull
    private final SignatureAlgorithm algorithm;
    @NotNull
    private final byte[] signatureBytes;
    @NotNull
    private final SignatureDataProto protobufRepresentation;

    private SignatureData(SignatureAlgorithm algorithm, byte[] signatureBytes, SignatureDataProto protobufRepresentation) {
        this.algorithm = algorithm;
        this.signatureBytes = signatureBytes;
        this.protobufRepresentation = protobufRepresentation;
    }

    @NotNull
    public final SignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final byte[] getSignatureBytes() {
        return this.signatureBytes;
    }

    @NotNull
    public final SignatureDataProto getProtobufRepresentation() {
        return this.protobufRepresentation;
    }

    public SignatureData(@NotNull SignatureDataProto protobufRepresentation) {
        Intrinsics.checkNotNullParameter((Object)protobufRepresentation, (String)"protobufRepresentation");
        Object object = protobufRepresentation.getAlgorithmId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"protobufRepresentation.algorithmId");
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.Companion.fromProtobufEnum((SignatureDataProto.AlgorithmId)((Object)object));
        object = protobufRepresentation.getSignatureBytes().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"protobufRepresentation.s\u2026natureBytes.toByteArray()");
        this(signatureAlgorithm, (byte[])object, protobufRepresentation);
    }

    public SignatureData(@NotNull SignatureAlgorithm algorithm, @NotNull byte[] signatureBytes) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)signatureBytes, (String)"signatureBytes");
        SignatureDataProto signatureDataProto = SignatureDataProto.newBuilder().setAlgorithmId(algorithm.toProtobufEnum()).setSignatureBytes(ByteString.copyFrom((byte[])signatureBytes)).build();
        Intrinsics.checkNotNullExpressionValue((Object)signatureDataProto, (String)"newBuilder()\n           \u2026es))\n            .build()");
        this(algorithm, signatureBytes, signatureDataProto);
    }
}

