/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.ListItemMarkerBlock;
import org.intellij.markdown.parser.markerblocks.impl.ListMarkerBlock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u000e*\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/ListMarkerProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "getLastExplicit", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;)Ljava/lang/Boolean;", "markdown"})
public final class ListMarkerProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        MarkdownConstraints currentConstraints = stateInfo.getCurrentConstraints();
        MarkdownConstraints nextConstraints = stateInfo.getNextConstraints();
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, currentConstraints)) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)nextConstraints, (Object)currentConstraints) ^ true) {
            Character c = ArraysKt.lastOrNull((char[])nextConstraints.getTypes());
            if ((c == null || c.charValue() != '>') && Intrinsics.areEqual((Object)this.getLastExplicit(nextConstraints), (Object)true)) {
                ArrayList<MarkerBlockImpl> result = new ArrayList<MarkerBlockImpl>();
                if (!(stateInfo.getLastBlock() instanceof ListMarkerBlock)) {
                    ProductionHolder.Marker marker = productionHolder.mark();
                    Character c2 = ArraysKt.lastOrNull((char[])nextConstraints.getTypes());
                    Intrinsics.checkNotNull((Object)c2);
                    result.add(new ListMarkerBlock(nextConstraints, marker, c2.charValue()));
                }
                result.add(new ListItemMarkerBlock(nextConstraints, productionHolder.mark()));
                return result;
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return false;
    }

    private final Boolean getLastExplicit(MarkdownConstraints $this$getLastExplicit) {
        return ArraysKt.lastOrNull((boolean[])$this$getLastExplicit.isExplicit());
    }
}

