/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.InMemoryStorageInterface;
import org.jetbrains.kotlin.incremental.storage.PersistentStorage;

@Metadata(k=1, mv={2, 0, 0}, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003B\u001b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u000f\u0010\u0018\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0015J\u000f\u0010\u0019\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0015R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u001b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR6\u0010\"\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010 j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`!8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R6\u0010&\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010 j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`!8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b&\u0010#\u001a\u0004\b'\u0010%R6\u0010(\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010 j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`!8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b(\u0010#\u001a\u0004\b)\u0010%R*\u0010,\u001a\u0012\u0012\u0004\u0012\u00028\u00000*j\b\u0012\u0004\u0012\u00028\u0000`+8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00028\u0000008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/InMemoryStorage;", "KEY", "VALUE", "Lorg/jetbrains/kotlin/incremental/storage/InMemoryStorageInterface;", "Lorg/jetbrains/kotlin/incremental/storage/PersistentStorage;", "storage", "<init>", "(Lorg/jetbrains/kotlin/incremental/storage/PersistentStorage;)V", "key", "", "contains", "(Ljava/lang/Object;)Z", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "value", "", "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", "remove", "(Ljava/lang/Object;)V", "applyChanges", "()V", "clearChanges", "flush", "close", "clean", "Lorg/jetbrains/kotlin/incremental/storage/PersistentStorage;", "Ljava/io/File;", "storageFile", "Ljava/io/File;", "getStorageFile", "()Ljava/io/File;", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "addedEntries", "Ljava/util/LinkedHashMap;", "getAddedEntries", "()Ljava/util/LinkedHashMap;", "modifiedEntries", "getModifiedEntries", "appendedEntries", "getAppendedEntries", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "removedKeys", "Ljava/util/LinkedHashSet;", "getRemovedKeys", "()Ljava/util/LinkedHashSet;", "", "getKeys", "()Ljava/util/Set;", "keys", "kotlin-build-common"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
@SourceDebugExtension(value={"SMAP\nInMemoryStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryStorage.kt\norg/jetbrains/kotlin/incremental/storage/InMemoryStorage\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n216#2,2:184\n216#2,2:186\n1869#3,2:188\n*S KotlinDebug\n*F\n+ 1 InMemoryStorage.kt\norg/jetbrains/kotlin/incremental/storage/InMemoryStorage\n*L\n107#1:184,2\n110#1:186,2\n114#1:188,2\n*E\n"})
public class InMemoryStorage<KEY, VALUE>
implements InMemoryStorageInterface<KEY, VALUE> {
    @NotNull
    private final PersistentStorage<KEY, VALUE> storage;
    @NotNull
    private final File storageFile;
    @NotNull
    private final LinkedHashMap<KEY, VALUE> addedEntries;
    @NotNull
    private final LinkedHashMap<KEY, VALUE> modifiedEntries;
    @NotNull
    private final LinkedHashMap<KEY, VALUE> appendedEntries;
    @NotNull
    private final LinkedHashSet<KEY> removedKeys;

    public InMemoryStorage(@NotNull PersistentStorage<KEY, VALUE> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        this.storage = storage;
        this.storageFile = this.storage.getStorageFile();
        this.addedEntries = new LinkedHashMap();
        this.modifiedEntries = new LinkedHashMap();
        this.appendedEntries = new LinkedHashMap();
        this.removedKeys = new LinkedHashSet();
    }

    @Override
    @NotNull
    public File getStorageFile() {
        return this.storageFile;
    }

    @NotNull
    protected final LinkedHashMap<KEY, VALUE> getAddedEntries() {
        return this.addedEntries;
    }

    @NotNull
    protected final LinkedHashMap<KEY, VALUE> getModifiedEntries() {
        return this.modifiedEntries;
    }

    @NotNull
    protected final LinkedHashMap<KEY, VALUE> getAppendedEntries() {
        return this.appendedEntries;
    }

    @NotNull
    protected final LinkedHashSet<KEY> getRemovedKeys() {
        return this.removedKeys;
    }

    @Override
    @NotNull
    public synchronized Set<KEY> getKeys() {
        Set<KEY> set = this.storage.getKeys();
        Set<KEY> set2 = this.addedEntries.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
        return SetsKt.minus((Set)SetsKt.plus(set, (Iterable)set2), (Iterable)this.removedKeys);
    }

    @Override
    public synchronized boolean contains(KEY key) {
        KEY KEY = key;
        return ((Map)this.addedEntries).containsKey(KEY) ? true : (((Map)this.modifiedEntries).containsKey(KEY) ? true : (((Map)this.appendedEntries).containsKey(KEY) ? true : (this.removedKeys.contains(KEY) ? false : this.storage.contains(key))));
    }

    @Override
    @Nullable
    public synchronized VALUE get(KEY key) {
        Object object = this.addedEntries.get(key);
        if (object == null && (object = this.modifiedEntries.get(key)) == null) {
            KEY KEY = key;
            object = this.removedKeys.contains(KEY) ? null : this.storage.get(key);
        }
        return object;
    }

    @Override
    public synchronized void set(KEY key, VALUE value2) {
        KEY KEY = key;
        if (((Map)this.addedEntries).containsKey(KEY)) {
            ((Map)this.addedEntries).put(key, value2);
        } else if (((Map)this.modifiedEntries).containsKey(KEY)) {
            ((Map)this.modifiedEntries).put(key, value2);
        } else if (((Map)this.appendedEntries).containsKey(KEY)) {
            this.appendedEntries.remove(key);
            ((Map)this.modifiedEntries).put(key, value2);
        } else if (this.removedKeys.contains(KEY)) {
            this.removedKeys.remove(key);
            ((Map)this.modifiedEntries).put(key, value2);
        } else if (this.storage.contains(KEY)) {
            ((Map)this.modifiedEntries).put(key, value2);
        } else {
            ((Map)this.addedEntries).put(key, value2);
        }
    }

    @Override
    public synchronized void remove(KEY key) {
        block1: {
            KEY KEY;
            block3: {
                block2: {
                    block0: {
                        KEY = key;
                        if (!((Map)this.addedEntries).containsKey(KEY)) break block0;
                        this.addedEntries.remove(key);
                        break block1;
                    }
                    if (!((Map)this.modifiedEntries).containsKey(KEY)) break block2;
                    this.modifiedEntries.remove(key);
                    this.removedKeys.add(key);
                    break block1;
                }
                if (!((Map)this.appendedEntries).containsKey(KEY)) break block3;
                this.appendedEntries.remove(key);
                this.removedKeys.add(key);
                break block1;
            }
            if (this.removedKeys.contains(KEY) || !this.storage.contains(KEY)) break block1;
            this.removedKeys.add(key);
        }
    }

    @Override
    public synchronized void applyChanges() {
        Map.Entry it;
        Map.Entry element$iv;
        Object $this$forEach$iv = this.addedEntries;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            this.storage.set(it.getKey(), it.getValue());
        }
        $this$forEach$iv = this.modifiedEntries;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            this.storage.set(it.getKey(), it.getValue());
        }
        $this$forEach$iv = this.removedKeys;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            this.storage.remove(it);
        }
        this.clearChanges();
    }

    @Override
    public synchronized void clearChanges() {
        this.addedEntries.clear();
        this.modifiedEntries.clear();
        this.appendedEntries.clear();
        this.removedKeys.clear();
    }

    @Override
    public synchronized void flush() {
        this.applyChanges();
        this.storage.flush();
    }

    @Override
    public synchronized void close() {
        this.applyChanges();
        this.storage.close();
    }

    @Override
    public synchronized void clean() {
        this.storage.clean();
    }
}

