/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.gradle.fus.BuildUidService;
import org.jetbrains.kotlin.gradle.logging.ErrorLoggingUtilKt;
import org.jetbrains.kotlin.gradle.logging.GradleKotlinLogger;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.statistics.BuildFinishBuildService;
import org.jetbrains.kotlin.gradle.plugin.statistics.BuildFinishFlowProviderManager;
import org.jetbrains.kotlin.gradle.plugin.statistics.BuildFusServiceKt;
import org.jetbrains.kotlin.gradle.plugin.statistics.FusUtilKt;
import org.jetbrains.kotlin.gradle.utils.PersistentCachesKt;
import org.jetbrains.kotlin.statistics.fileloggers.MetricsContainer;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\r\u0010\u0010\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0011J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0013H\u0002R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFinishBuildService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFinishBuildService$Parameters;", "Ljava/lang/AutoCloseable;", "()V", "buildId", "", "kotlin.jvm.PlatformType", "getBuildId", "()Ljava/lang/String;", "errorWasReported", "Ljava/util/concurrent/atomic/AtomicBoolean;", "log", "Lorg/gradle/api/logging/Logger;", "close", "", "collectAllFusReportsIntoOne", "collectAllFusReportsIntoOne$kotlin_gradle_plugin_common", "errorFile", "Ljava/io/File;", "Companion", "Parameters", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nBuildFinishBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildFinishBuildService.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/BuildFinishBuildService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1549#2:130\n1620#2,3:131\n*S KotlinDebug\n*F\n+ 1 BuildFinishBuildService.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/BuildFinishBuildService\n*L\n123#1:130\n123#1:131,3\n*E\n"})
public abstract class BuildFinishBuildService
implements BuildService<Parameters>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final String buildId = (String)((Parameters)this.getParameters()).getBuildId().get();
    private final Logger log = Logging.getLogger(this.getClass());
    @NotNull
    private final AtomicBoolean errorWasReported = new AtomicBoolean(false);
    @NotNull
    private static final String serviceName = BuildFinishBuildService.class.getCanonicalName() + '_' + BuildFinishBuildService.class.getClassLoader().hashCode();

    protected final String getBuildId() {
        return this.buildId;
    }

    @Override
    public void close() {
        this.log.debug("Build service " + serviceName + " closed for build " + this.buildId);
    }

    private final File errorFile(File $this$errorFile) {
        return FilesKt.resolve((File)$this$errorFile, (String)("errors-" + this.buildId + '-' + System.currentTimeMillis() + ".log"));
    }

    /*
     * WARNING - void declaration
     */
    public final void collectAllFusReportsIntoOne$kotlin_gradle_plugin_common() {
        String string = this.buildId;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buildId");
        Object object = ((Parameters)this.getParameters()).getFusReportDirectory().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.fusReportDirectory.get()");
        File file2 = (File)object;
        Object object2 = ((Parameters)this.getParameters()).getKotlinVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.kotlinVersion.get()");
        String string2 = (String)object2;
        Logger logger2 = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        List<String> errorMessages = Companion.collectAllFusReportsIntoOne$kotlin_gradle_plugin_common(string, file2, string2, logger2);
        if (!((Collection)errorMessages).isEmpty() && this.errorWasReported.compareAndSet(false, true)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object3 = ((Parameters)this.getParameters()).getErrorDirs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.errorDirs.get()");
            Iterable iterable = (Iterable)object3;
            List<String> list = errorMessages;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file3 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(this.errorFile((File)it));
            }
            Collection collection = (List)destination$iv$iv;
            String string3 = (String)((Parameters)this.getParameters()).getKotlinVersion().get();
            Logger logger3 = this.log;
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"log");
            ErrorLoggingUtilKt.reportToIde(list, collection, string3, this.buildId, (KotlinLogger)new GradleKotlinLogger(logger3, null, false, 6, null));
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00040\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFinishBuildService$Companion;", "", "()V", "serviceName", "", "collectAllFusReportsIntoOne", "", "Lorg/jetbrains/kotlin/gradle/logging/Errors;", "buildUid", "fusReportDirectory", "Ljava/io/File;", "kotlinVersion", "log", "Lorg/gradle/api/logging/Logger;", "collectAllFusReportsIntoOne$kotlin_gradle_plugin_common", "registerIfAbsent", "", "project", "Lorg/gradle/api/Project;", "buildUidService", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/fus/BuildUidService;", "kotlinPluginVersion", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nBuildFinishBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildFinishBuildService.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/BuildFinishBuildService$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n3792#2:130\n4307#2,2:131\n1851#3,2:133\n*S KotlinDebug\n*F\n+ 1 BuildFinishBuildService.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/BuildFinishBuildService$Companion\n*L\n82#1:130\n82#1:131,2\n83#1:133,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerIfAbsent(@NotNull Project project, @NotNull Provider<BuildUidService> buildUidService, @NotNull String kotlinPluginVersion) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(buildUidService, (String)"buildUidService");
            Intrinsics.checkNotNullParameter((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
            if (!BuildFusServiceKt.getBuildServiceShouldBeCreated(project)) {
                return;
            }
            if (project.getGradle().getSharedServices().getRegistrations().findByName(serviceName) != null) {
                return;
            }
            File reportDir = FusUtilKt.getFusDirectoryFromPropertyService(project);
            boolean useFlowAction = GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.1")) >= 0;
            project.getGradle().getSharedServices().registerIfAbsent(serviceName, BuildFinishBuildService.class, new Action(buildUidService, reportDir, project, kotlinPluginVersion){
                final /* synthetic */ Provider<BuildUidService> $buildUidService;
                final /* synthetic */ File $reportDir;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $kotlinPluginVersion;
                {
                    this.$buildUidService = $buildUidService;
                    this.$reportDir = $reportDir;
                    this.$project = $project;
                    this.$kotlinPluginVersion = $kotlinPluginVersion;
                }

                public final void execute(BuildServiceSpec<Parameters> spec) {
                    ((Parameters)spec.getParameters()).getBuildId().value(this.$buildUidService.map((Transformer)registerIfAbsent.1.INSTANCE)).disallowChanges();
                    ((Parameters)spec.getParameters()).getFusReportDirectory().value((Object)this.$reportDir).disallowChanges();
                    ((Parameters)spec.getParameters()).getErrorDirs().add((Object)PersistentCachesKt.getKotlinErrorsDir(this.$project));
                    if (!PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(this.$project).getKotlinProjectPersistentDirGradleDisableWrite()) {
                        ListProperty<File> listProperty = ((Parameters)spec.getParameters()).getErrorDirs();
                        File file2 = this.$project.getRootDir();
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.rootDir");
                        listProperty.add((Object)FilesKt.resolve((File)file2, (String)".gradle/kotlin/errors/"));
                    }
                    ((Parameters)spec.getParameters()).getErrorDirs().disallowChanges();
                    ((Parameters)spec.getParameters()).getKotlinVersion().value((Object)this.$kotlinPluginVersion).disallowChanges();
                }
            }).get();
            if (useFlowAction) {
                BuildFinishFlowProviderManager.Companion.getInstance$kotlin_gradle_plugin_common(project).subscribeForBuildResults$kotlin_gradle_plugin_common();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @NotNull
        public final List<String> collectAllFusReportsIntoOne$kotlin_gradle_plugin_common(@NotNull String buildUid, @NotNull File fusReportDirectory, @NotNull String kotlinVersion, @NotNull Logger log) {
            Intrinsics.checkNotNullParameter((Object)buildUid, (String)"buildUid");
            Intrinsics.checkNotNullParameter((Object)fusReportDirectory, (String)"fusReportDirectory");
            Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            try {
                metricContainer = new MetricsContainer(false, 1, null);
                v0 = fusReportDirectory.listFiles();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"fusReportDirectory.listFiles()");
                var6_7 = v0;
                $i$f$filter = false;
                var8_10 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    it = (File)element$iv$iv;
                    $i$a$-filter-BuildFinishBuildService$Companion$collectAllFusReportsIntoOne$1 = false;
                    v1 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.name");
                    if (!StringsKt.startsWith$default((String)v1, (String)buildUid, (boolean)false, (int)2, null)) ** GOTO lbl-1000
                    v2 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it.name");
                    if (StringsKt.endsWith$default((String)v2, (String)"plugin-profile", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                    v3 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it.name");
                    if (StringsKt.endsWith$default((String)v3, (String)"kotlin-profile", (boolean)false, (int)2, null)) lbl-1000:
                    // 2 sources

                    {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
                    if (!v4) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (File)element$iv;
                    $i$a$-forEach-BuildFinishBuildService$Companion$collectAllFusReportsIntoOne$2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    MetricsContainer.Companion.readFromFile(it, (Function1<? super MetricsContainer, Unit>)((Function1)new Function1<MetricsContainer, Unit>(metricContainer){
                        final /* synthetic */ MetricsContainer $metricContainer;
                        {
                            this.$metricContainer = $metricContainer;
                            super(1);
                        }

                        public final void invoke(MetricsContainer it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.$metricContainer.populateFromMetricsContainer(it);
                        }
                    }));
                }
                fusFile = FilesKt.resolve((File)fusReportDirectory, (String)(buildUid + ".profile"));
                var7_9 = fusFile;
                var8_10 = Charsets.UTF_8;
                var7_9 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)var7_9), (Charset)var8_10);
                var8_11 = 8192;
                var7_9 = var7_9 instanceof BufferedWriter != false ? (BufferedWriter)var7_9 : new BufferedWriter((Writer)var7_9, var8_11);
                var8_12 = null;
                try {
                    it = (BufferedWriter)var7_9;
                    $i$a$-use-BuildFinishBuildService$Companion$collectAllFusReportsIntoOne$3 = false;
                    v5 = ((Appendable)it).append("Build: " + buildUid);
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)v5.append('\n'), (String)"append('\\n')");
                    v6 = ((Appendable)it).append("Kotlin version: " + kotlinVersion);
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)v6.append('\n'), (String)"append('\\n')");
                    metricContainer.flush(it);
                    var9_13 = Unit.INSTANCE;
                }
                catch (Throwable var9_14) {
                    var8_12 = var9_14;
                    throw var9_14;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var7_9, (Throwable)var8_12);
                }
                if (!FilesKt.resolve((File)fusReportDirectory, (String)(buildUid + ".finish-profile")).createNewFile()) {
                    log.debug("File " + fusReportDirectory + '/' + buildUid + ".finish-profile already exists");
                    return CollectionsKt.listOf((Object)("File " + fusReportDirectory + '/' + buildUid + ".finish-profile already exists"));
                }
            }
            catch (Exception e) {
                log.debug("Unable to collect finish file for build " + buildUid + ": " + e.getMessage());
                v7 = new StringBuilder().append("Error while creating finish file: ").append(e.getMessage());
                v8 = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"e.stackTrace");
                return CollectionsKt.listOf((Object)v7.append(ArraysKt.joinToString$default((Object[])v8, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString());
            }
            log.debug("Single fus file was created for build " + buildUid + ' ');
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFinishBuildService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "buildId", "Lorg/gradle/api/provider/Property;", "", "getBuildId", "()Lorg/gradle/api/provider/Property;", "errorDirs", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getErrorDirs", "()Lorg/gradle/api/provider/ListProperty;", "fusReportDirectory", "getFusReportDirectory", "kotlinVersion", "getKotlinVersion", "kotlin-gradle-plugin_common"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<String> getBuildId();

        @NotNull
        public Property<File> getFusReportDirectory();

        @NotNull
        public Property<String> getKotlinVersion();

        @NotNull
        public ListProperty<File> getErrorDirs();
    }
}

