/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadata;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadataKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.ProjectPathWithBuildPath;
import org.jetbrains.kotlin.gradle.utils.CurrentBuildIdentifierKt;
import org.jetbrains.kotlin.gradle.utils.GradleUtilsKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\t*\u00020\u0001H\u0002J\f\u0010\u0014\u001a\u00020\u0007*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/GlobalProjectStructureMetadataStorage;", "", "()V", "propertyPrefix", "", "getProjectStructureMetadataProvidersFromAllGradleBuilds", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/ProjectPathWithBuildPath;", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;", "project", "Lorg/gradle/api/Project;", "propertyName", "buildName", "projectPath", "registerProjectStructureMetadata", "", "metadataProvider", "Lkotlin/Function0;", "getProjectStructureMetadataOrNull", "toProjectPathWithBuildName", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nKotlinProjectStructureMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProjectStructureMetadata.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/GlobalProjectStructureMetadataStorage\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,463:1\n463#2,7:464\n1179#3,2:471\n1253#3,4:473\n*S KotlinDebug\n*F\n+ 1 KotlinProjectStructureMetadata.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/GlobalProjectStructureMetadataStorage\n*L\n425#1:464,7\n427#1:471,2\n427#1:473,4\n*E\n"})
public final class GlobalProjectStructureMetadataStorage {
    @NotNull
    public static final GlobalProjectStructureMetadataStorage INSTANCE = new GlobalProjectStructureMetadataStorage();
    @NotNull
    private static final String propertyPrefix = "kotlin.projectStructureMetadata.build";

    private GlobalProjectStructureMetadataStorage() {
    }

    @NotNull
    public final String propertyName(@NotNull String buildName, @NotNull String projectPath2) {
        Intrinsics.checkNotNullParameter((Object)buildName, (String)"buildName");
        Intrinsics.checkNotNullParameter((Object)projectPath2, (String)"projectPath");
        return "kotlin.projectStructureMetadata.build." + buildName + ".path." + projectPath2;
    }

    public final void registerProjectStructureMetadata(@NotNull Project project, @NotNull Function0<KotlinProjectStructureMetadata> metadataProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(metadataProvider, (String)"metadataProvider");
        GradleUtilsKt.compositeBuildRootProject(project, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(project, metadataProvider){
            final /* synthetic */ Project $project;
            final /* synthetic */ Function0<KotlinProjectStructureMetadata> $metadataProvider;
            {
                this.$project = $project;
                this.$metadataProvider = $metadataProvider;
                super(1);
            }

            public final void invoke(Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ExtraPropertiesExtension extraPropertiesExtension = ((ExtensionAware)it).getExtensions().getExtraProperties();
                String string = GradleUtilsKt.getBuildPathCompat(CurrentBuildIdentifierKt.currentBuildId(this.$project));
                String string2 = this.$project.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.path");
                extraPropertiesExtension.set(GlobalProjectStructureMetadataStorage.INSTANCE.propertyName(string, string2), (Object)new Function0<String>(this.$metadataProvider){
                    final /* synthetic */ Function0<KotlinProjectStructureMetadata> $metadataProvider;
                    {
                        this.$metadataProvider = $metadataProvider;
                        super(0);
                    }

                    public final String invoke() {
                        return KotlinProjectStructureMetadataKt.toJson((KotlinProjectStructureMetadata)this.$metadataProvider.invoke());
                    }
                });
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ProjectPathWithBuildPath, Lazy<KotlinProjectStructureMetadata>> getProjectStructureMetadataProvidersFromAllGradleBuilds(@NotNull Project project) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map map = GradleUtilsKt.getCompositeBuildRootProject(project).getExtensions().getExtraProperties().getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"project.compositeBuildRo\u2026xtraProperties.properties");
        Map $this$filterKeys$iv = map;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!StringsKt.startsWith$default((String)it, (String)propertyPrefix, (boolean)false, (int)2, null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$associate$iv = ((Map)result$iv).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String propertyName = (String)entry2.getKey();
            Object propertyValue = entry2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)propertyName, (String)"propertyName");
            entry2 = new Pair((Object)INSTANCE.toProjectPathWithBuildName(propertyName), (Object)LazyKt.lazy((Function0)((Function0)new Function0<KotlinProjectStructureMetadata>(propertyValue){
                final /* synthetic */ Object $propertyValue;
                {
                    this.$propertyValue = $propertyValue;
                    super(0);
                }

                public final KotlinProjectStructureMetadata invoke() {
                    Object object = this.$propertyValue;
                    return object != null ? GlobalProjectStructureMetadataStorage.access$getProjectStructureMetadataOrNull(GlobalProjectStructureMetadataStorage.INSTANCE, object) : null;
                }
            })));
            map2.put(entry2.getFirst(), entry2.getSecond());
        }
        return destination$iv$iv;
    }

    private final KotlinProjectStructureMetadata getProjectStructureMetadataOrNull(Object $this$getProjectStructureMetadataOrNull) {
        Function0 function0 = TypeIntrinsics.isFunctionOfArity((Object)$this$getProjectStructureMetadataOrNull, (int)0) ? (Function0)$this$getProjectStructureMetadataOrNull : null;
        if (function0 == null) {
            return null;
        }
        Function0 jsonStringProvider = function0;
        Object object = jsonStringProvider.invoke();
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return null;
        }
        String jsonString = string;
        return KotlinProjectStructureMetadataKt.parseKotlinSourceSetMetadataFromJson(jsonString);
    }

    private final ProjectPathWithBuildPath toProjectPathWithBuildName(String $this$toProjectPathWithBuildName) {
        String[] stringArray = new String[]{".path."};
        List list = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)$this$toProjectPathWithBuildName, (CharSequence)"kotlin.projectStructureMetadata.build."), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String buildPath = (String)list.get(0);
        String projectPath2 = (String)list.get(1);
        return new ProjectPathWithBuildPath(projectPath2, buildPath);
    }

    public static final /* synthetic */ KotlinProjectStructureMetadata access$getProjectStructureMetadataOrNull(GlobalProjectStructureMetadataStorage $this, Object $receiver) {
        return $this.getProjectStructureMetadataOrNull($receiver);
    }
}

