/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import org.jetbrains.kotlin.org.apache.commons.io.filefilter.AbstractFileFilter;
import org.jetbrains.kotlin.org.apache.commons.io.filefilter.IOFileFilter;

public class NotFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 6131563330944994230L;
    private final IOFileFilter filter;

    public NotFileFilter(IOFileFilter filter2) {
        Objects.requireNonNull(filter2, "filter");
        this.filter = filter2;
    }

    @Override
    public boolean accept(File file) {
        return !this.filter.accept(file);
    }

    @Override
    public boolean accept(File file, String name2) {
        return !this.filter.accept(file, name2);
    }

    @Override
    public FileVisitResult accept(Path file, BasicFileAttributes attributes2) {
        return this.not(this.filter.accept(file, attributes2));
    }

    private FileVisitResult not(FileVisitResult accept) {
        return accept == FileVisitResult.CONTINUE ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    @Override
    public String toString() {
        return "NOT (" + this.filter.toString() + ")";
    }
}

