/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B4\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012#\b\u0002\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003J4\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u0002H\u000e0\u0005\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0002R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizerLock;", "", "outputDirectory", "Ljava/io/File;", "logInfo", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "message", "", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;)V", "checkLocked", "withLock", "T", "action", "lockFile", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "lockWithRetries", "Ljava/nio/channels/FileLock;", "Ljava/nio/channels/FileChannel;", "file", "Companion", "kotlin-gradle-plugin_common"})
public final class NativeDistributionCommonizerLock {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final File outputDirectory;
    @NotNull
    private final Function1<String, Unit> logInfo;
    @NotNull
    private static final ReentrantLock intraProcessLock = new ReentrantLock();
    @NotNull
    private static final HashSet<File> lockedOutputDirectories = new HashSet();

    @JvmOverloads
    public NativeDistributionCommonizerLock(@NotNull File outputDirectory2, @NotNull Function1<? super String, Unit> logInfo) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory2, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter(logInfo, (String)"logInfo");
        this.outputDirectory = outputDirectory2;
        this.logInfo = logInfo;
    }

    public /* synthetic */ NativeDistributionCommonizerLock(File file, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(file, (Function1<? super String, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withLock(@NotNull Function1<? super File, ? extends T> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        Lock lock2 = intraProcessLock;
        lock2.lock();
        try {
            Object object;
            boolean bl = false;
            File lockFile = FilesKt.resolve((File)this.outputDirectory, (String)".lock");
            if (lockedOutputDirectories.contains(this.outputDirectory)) {
                Object object2 = action2.invoke((Object)lockFile);
                return (T)object2;
            }
            this.outputDirectory.mkdirs();
            this.logInfo.invoke((Object)("Acquire lock: " + lockFile.getPath() + " ..."));
            Closeable closeable = new FileOutputStream(FilesKt.resolve((File)this.outputDirectory, (String)".lock"));
            Throwable throwable = null;
            try {
                Object object3;
                FileOutputStream stream = (FileOutputStream)closeable;
                boolean bl2 = false;
                FileChannel fileChannel = stream.getChannel();
                Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"stream.channel");
                FileLock lock3 = this.lockWithRetries(fileChannel, lockFile);
                boolean bl3 = lock3.isValid();
                if (_Assertions.ENABLED && !bl3) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                try {
                    this.logInfo.invoke((Object)("Lock acquired: " + lockFile.getPath()));
                    lockedOutputDirectories.add(this.outputDirectory);
                    object3 = action2.invoke((Object)lockFile);
                }
                finally {
                    lockedOutputDirectories.remove(this.outputDirectory);
                    lock3.release();
                    this.logInfo.invoke((Object)("Lock released: " + lockFile.getPath()));
                }
                object = object3;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)closeable, throwable);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            Object object4 = object;
            return (T)object4;
        }
        finally {
            lock2.unlock();
        }
    }

    private final FileLock lockWithRetries(FileChannel $this$lockWithRetries, File file) {
        int retries = 0;
        while (true) {
            try {
                FileLock fileLock = $this$lockWithRetries.lock();
                Intrinsics.checkNotNullExpressionValue((Object)fileLock, (String)"lock()");
                return fileLock;
            }
            catch (OverlappingFileLockException t) {
                Thread.sleep(25L);
                if (++retries % 10 != 0) continue;
                this.logInfo.invoke((Object)("Waiting to acquire lock: " + file));
                continue;
            }
            break;
        }
    }

    public final void checkLocked(@NotNull File outputDirectory2) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory2, (String)"outputDirectory");
        if (!intraProcessLock.isHeldByCurrentThread()) {
            boolean $i$a$-check-NativeDistributionCommonizerLock$checkLocked$32 = false;
            String $i$a$-check-NativeDistributionCommonizerLock$checkLocked$32 = "Expected lock to be held by current thread " + Thread.currentThread().getName();
            throw new IllegalStateException($i$a$-check-NativeDistributionCommonizerLock$checkLocked$32.toString());
        }
        if (!lockedOutputDirectories.contains(outputDirectory2)) {
            boolean bl = false;
            String string = "Expected " + outputDirectory2 + " to be locked. Locked directories: " + lockedOutputDirectories;
            throw new IllegalStateException(string.toString());
        }
    }

    @JvmOverloads
    public NativeDistributionCommonizerLock(@NotNull File outputDirectory2) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory2, (String)"outputDirectory");
        this(outputDirectory2, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizerLock$Companion;", "", "()V", "intraProcessLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getIntraProcessLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "lockedOutputDirectories", "Ljava/util/HashSet;", "Ljava/io/File;", "Lkotlin/collections/HashSet;", "getLockedOutputDirectories", "()Ljava/util/HashSet;", "kotlin-gradle-plugin_common"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReentrantLock getIntraProcessLock() {
            return intraProcessLock;
        }

        @NotNull
        public final HashSet<File> getLockedOutputDirectories() {
            return lockedOutputDirectories;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

