/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmNameAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "isRenamableFunction", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "frontend.java"})
public final class JvmNameAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AnnotationDescriptor jvmNameAnnotation = DescriptorUtils.findJvmNameAnnotation(descriptor);
        if (jvmNameAnnotation != null) {
            this.checkDeclaration(descriptor, jvmNameAnnotation, context.getTrace());
        }
    }

    private final void checkDeclaration(DeclarationDescriptor descriptor, AnnotationDescriptor annotation, DiagnosticSink diagnosticHolder) {
        String value2;
        KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotation);
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        if (descriptor instanceof FunctionDescriptor && !this.isRenamableFunction((FunctionDescriptor)descriptor)) {
            diagnosticHolder.report(ErrorsJvm.INAPPLICABLE_JVM_NAME.on(annotationEntry));
        }
        if ((value2 = DescriptorUtils.getJvmName(descriptor)) == null || !Name.isValidIdentifier(value2)) {
            diagnosticHolder.report(ErrorsJvm.ILLEGAL_JVM_NAME.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }
        if (descriptor instanceof CallableMemberDescriptor) {
            if (DescriptorUtils.isOverride((CallableMemberDescriptor)descriptor) || ModalityUtilsKt.isOverridable((CallableMemberDescriptor)descriptor)) {
                diagnosticHolder.report(ErrorsJvm.INAPPLICABLE_JVM_NAME.on(annotationEntry));
            } else {
                DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
                if (InlineClassManglingRulesKt.isValueClassThatRequiresMangling(declarationDescriptor)) {
                    diagnosticHolder.report(ErrorsJvm.INAPPLICABLE_JVM_NAME.on(annotationEntry));
                }
            }
        }
    }

    private final boolean isRenamableFunction(FunctionDescriptor descriptor) {
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor containingDescriptor = declarationDescriptor;
        return containingDescriptor instanceof PackageFragmentDescriptor || containingDescriptor instanceof ClassDescriptor;
    }
}

