/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.registry.EarlyAccessRegistryManager;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/plugins/DisabledPluginsState;", "Lcom/intellij/ide/plugins/PluginEnabler$Headless;", "()V", "disable", "", "descriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "enable", "isDisabled", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "isIgnoredDisabledPlugins", "setIgnoredDisabledPlugins", "", "ignoredDisabledPlugins", "Companion", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class DisabledPluginsState
implements PluginEnabler.Headless {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static volatile Set<PluginId> disabledPlugins;
    @NotNull
    private static final CopyOnWriteArrayList<Runnable> ourDisabledPluginListeners;
    private static volatile boolean isDisabledStateIgnored;

    @Override
    public boolean isIgnoredDisabledPlugins() {
        return isDisabledStateIgnored;
    }

    @Override
    public void setIgnoredDisabledPlugins(boolean ignoredDisabledPlugins) {
        isDisabledStateIgnored = ignoredDisabledPlugins;
    }

    static {
        ourDisabledPluginListeners = new CopyOnWriteArrayList();
        isDisabledStateIgnored = EarlyAccessRegistryManager.INSTANCE.getBoolean("idea.ignore.disabled.plugins");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0006\u0010\u001c\u001a\u00020\u0018J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016J \u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00072\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#H\u0007J\u0014\u0010 \u001a\u00020\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001e\u0010$\u001a\u00020\u000e2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020\u000eH\u0001J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010*\u001a\u00020\u0004H\u0002J\u001e\u0010+\u001a\u00020\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/ide/plugins/DisabledPluginsState$Companion;", "", "()V", "DISABLED_PLUGINS_FILENAME", "", "Lorg/jetbrains/annotations/NonNls;", "defaultFilePath", "Ljava/nio/file/Path;", "getDefaultFilePath", "()Ljava/nio/file/Path;", "disabledPlugins", "", "Lcom/intellij/openapi/extensions/PluginId;", "isDisabledStateIgnored", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "ourDisabledPluginListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/lang/Runnable;", "addDisablePluginListener", "", "listener", "getDisabledIds", "getRequiredPlugins", "invalidate", "loadDisabledPlugins", "path", "removeDisablePluginListener", "saveDisabledPluginsAndInvalidate", "configPath", "pluginIds", "", "setEnabledState", "descriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "enabled", "splitByComma", "key", "trySaveDisabledPlugins", "intellij.platform.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDisabledPluginsState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisabledPluginsState.kt\ncom/intellij/ide/plugins/DisabledPluginsState$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1#2:165\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getDefaultFilePath() {
            Path path = PathManager.getConfigDir().resolve("disabled_plugins.txt");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private final Logger getLogger() {
            Logger logger = Logger.getInstance("#com.intellij.ide.plugins.DisabledPluginsState");
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return logger;
        }

        @NotNull
        public final Set<PluginId> getRequiredPlugins() {
            return this.splitByComma("idea.required.plugins.id");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Set<PluginId> loadDisabledPlugins(@NotNull Path path) {
            Set<PluginId> suppressedPluginIds;
            Set<PluginId> pluginIdsFromFile;
            boolean updateFile;
            Set<PluginId> requiredPlugins;
            LinkedHashSet<PluginId> disabledPlugins2;
            block8: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                disabledPlugins2 = new LinkedHashSet<PluginId>();
                requiredPlugins = this.getRequiredPlugins();
                updateFile = false;
                pluginIdsFromFile = PluginManagerCoreKt.tryReadPluginIdsFromFile(path, this.getLogger());
                suppressedPluginIds = this.splitByComma("idea.suppressed.plugins.id");
                if (!pluginIdsFromFile.isEmpty() || !suppressedPluginIds.isEmpty()) break block8;
                Set set = SetsKt.emptySet();
                return set;
            }
            try {
                ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getShadowInstance(...)");
                ApplicationInfoEx applicationInfo = applicationInfoEx;
                for (PluginId id : pluginIdsFromFile) {
                    if (!requiredPlugins.contains(id) && !applicationInfo.isEssentialPlugin(id)) {
                        disabledPlugins2.add(id);
                        continue;
                    }
                    updateFile = true;
                }
                for (PluginId suppressedPluginId : suppressedPluginIds) {
                    if (applicationInfo.isEssentialPlugin(suppressedPluginId) || !disabledPlugins2.add(suppressedPluginId)) continue;
                    updateFile = true;
                }
                Set set = disabledPlugins2;
                return set;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (updateFile) {
                    this.trySaveDisabledPlugins((Set<PluginId>)disabledPlugins2, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Set<PluginId> getDisabledIds() {
            Set set = disabledPlugins;
            if (set != null) {
                Set it = set;
                boolean bl = false;
                return it;
            }
            if (isDisabledStateIgnored) {
                Set<PluginId> set2 = Collections.emptySet();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"emptySet(...)");
                return set2;
            }
            Class<DisabledPluginsState> clazz = DisabledPluginsState.class;
            synchronized (clazz) {
                boolean bl = false;
                Set<PluginId> result2 = disabledPlugins;
                if (result2 == null) {
                    Set<PluginId> set3 = Collections.unmodifiableSet(Companion.loadDisabledPlugins(Companion.getDefaultFilePath()));
                    Intrinsics.checkNotNull(set3);
                    result2 = set3;
                    disabledPlugins = result2;
                }
                Set<PluginId> set4 = result2;
                return set4;
            }
        }

        private final boolean trySaveDisabledPlugins(Set<PluginId> pluginIds, boolean invalidate) {
            if (!PluginManagerCore.tryWritePluginIdsToFile$default(PluginManagerCore.INSTANCE, this.getDefaultFilePath(), pluginIds, this.getLogger(), null, 8, null)) {
                return false;
            }
            if (invalidate) {
                this.invalidate();
            }
            for (Runnable listener : ourDisabledPluginListeners) {
                listener.run();
            }
            return true;
        }

        public final void invalidate() {
            disabledPlugins = null;
        }

        private final Set<PluginId> splitByComma(String key) {
            Set<PluginId> set;
            String property = System.getProperty(key, "");
            Intrinsics.checkNotNull((Object)property);
            if (((CharSequence)property).length() == 0) {
                set = SetsKt.emptySet();
            } else {
                char[] cArray = new char[]{','};
                set = PluginManagerCore.toPluginIds(StringsKt.split$default((CharSequence)property, (char[])cArray, (boolean)false, (int)0, (int)6, null));
            }
            return set;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

