/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.checkers.EmptyIntersectionTypeInfo;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.EmptyIntersectionTypeKind;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.IntersectionTypeConstructorMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContext;
import org.jetbrains.kotlin.types.model.TypeSystemContextContextualKt;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContextContextualKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ+\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J!\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\nH\u0002R\u00020\u0006j\u0006\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b\u00b2\u0006\n\u0010\u001c\u001a\u00020\nX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u0013\u001a\u00020\u0014X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/EmptyIntersectionTypeChecker;", "", "<init>", "()V", "computeEmptyIntersectionEmptiness", "Lorg/jetbrains/kotlin/resolve/checkers/EmptyIntersectionTypeInfo;", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "c", "types", "", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "(Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;Ljava/util/Collection;)Lorg/jetbrains/kotlin/resolve/checkers/EmptyIntersectionTypeInfo;", "computeByHavingCommonSubtype", "first", "second", "(Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;)Lorg/jetbrains/kotlin/resolve/checkers/EmptyIntersectionTypeInfo;", "isSubtypeOfIgnoringArguments", "", "Lorg/jetbrains/kotlin/types/model/RigidTypeMarker;", "typeCheckerState", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "otherConstructorMarker", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "mayCauseEmptyIntersection", "context", "type", "(Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;)Z", "compiler.common", "firstSubstitutedType"})
public final class EmptyIntersectionTypeChecker {
    @NotNull
    public static final EmptyIntersectionTypeChecker INSTANCE = new EmptyIntersectionTypeChecker();

    private EmptyIntersectionTypeChecker() {
    }

    @Nullable
    public final EmptyIntersectionTypeInfo computeEmptyIntersectionEmptiness(@NotNull TypeSystemInferenceExtensionContext c2, @NotNull Collection<? extends KotlinTypeMarker> types2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        Intrinsics.checkNotNullParameter(types2, (String)"types");
        if (types2.isEmpty()) {
            return null;
        }
        List types3 = CollectionsKt.toList((Iterable)types2);
        EmptyIntersectionTypeInfo possibleEmptyIntersectionTypeInfo = null;
        int n2 = ((Collection)types3).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            KotlinTypeMarker firstType = (KotlinTypeMarker)types3.get(i2);
            if (!this.mayCauseEmptyIntersection(c2, firstType)) continue;
            Lazy firstSubstitutedType$delegate = LazyKt.lazy(() -> EmptyIntersectionTypeChecker.computeEmptyIntersectionEmptiness$lambda$0(c2, firstType));
            int n3 = types3.size();
            for (int j2 = i2 + 1; j2 < n3; ++j2) {
                EmptyIntersectionTypeInfo typeInfo;
                KotlinTypeMarker secondSubstitutedType;
                KotlinTypeMarker secondType = (KotlinTypeMarker)types3.get(j2);
                if (!this.mayCauseEmptyIntersection(c2, secondType) || !this.mayCauseEmptyIntersection(c2, secondSubstitutedType = TypeSystemInferenceExtensionContextContextualKt.eraseContainingTypeParameters(c2, secondType)) && !this.mayCauseEmptyIntersection(c2, EmptyIntersectionTypeChecker.computeEmptyIntersectionEmptiness$lambda$1((Lazy<? extends KotlinTypeMarker>)firstSubstitutedType$delegate)) || this.computeByHavingCommonSubtype(c2, EmptyIntersectionTypeChecker.computeEmptyIntersectionEmptiness$lambda$1((Lazy<? extends KotlinTypeMarker>)firstSubstitutedType$delegate), secondSubstitutedType) == null) continue;
                if (typeInfo.getKind().isDefinitelyEmpty()) {
                    return typeInfo;
                }
                if (typeInfo.getKind().isDefinitelyEmpty()) continue;
                possibleEmptyIntersectionTypeInfo = typeInfo;
            }
        }
        return possibleEmptyIntersectionTypeInfo;
    }

    private final EmptyIntersectionTypeInfo computeByHavingCommonSubtype(TypeSystemInferenceExtensionContext c2, KotlinTypeMarker first, KotlinTypeMarker second) {
        List expandedTypes = CollectionsKt.plus((Collection)EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$extractIntersectionComponentsIfNeeded(c2, first), (Iterable)EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$extractIntersectionComponentsIfNeeded(c2, second));
        Lazy typeCheckerState$delegate = LazyKt.lazy(() -> EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$lambda$0(c2));
        EmptyIntersectionTypeInfo possibleEmptyIntersectionKind = null;
        int n2 = ((Collection)expandedTypes).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            KotlinTypeMarker firstType = TypeSystemContextContextualKt.withNullability((TypeSystemContext)c2, (KotlinTypeMarker)expandedTypes.get(i2), false);
            TypeConstructorMarker firstTypeConstructor = TypeSystemContextContextualKt.typeConstructor((TypeSystemContext)c2, firstType);
            if (!this.mayCauseEmptyIntersection(c2, firstType)) continue;
            int n3 = expandedTypes.size();
            for (int j2 = i2 + 1; j2 < n3; ++j2) {
                KotlinTypeMarker[] kotlinTypeMarkerArray;
                KotlinTypeMarker secondType = TypeSystemContextContextualKt.withNullability((TypeSystemContext)c2, (KotlinTypeMarker)expandedTypes.get(j2), false);
                TypeConstructorMarker secondTypeConstructor = TypeSystemContextContextualKt.typeConstructor((TypeSystemContext)c2, secondType);
                if (!this.mayCauseEmptyIntersection(c2, secondType) || c2.areEqualTypeConstructors(firstTypeConstructor, secondTypeConstructor) || this.isSubtypeOfIgnoringArguments(TypeSystemContextContextualKt.lowerBoundIfFlexible((TypeSystemContext)c2, firstType), EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$lambda$1((Lazy<? extends TypeCheckerState>)typeCheckerState$delegate), secondTypeConstructor) || this.isSubtypeOfIgnoringArguments(TypeSystemContextContextualKt.lowerBoundIfFlexible((TypeSystemContext)c2, secondType), EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$lambda$1((Lazy<? extends TypeCheckerState>)typeCheckerState$delegate), firstTypeConstructor)) continue;
                if (!TypeSystemContextContextualKt.isInterface(c2, firstTypeConstructor) && !TypeSystemContextContextualKt.isInterface(c2, secondTypeConstructor)) {
                    kotlinTypeMarkerArray = new KotlinTypeMarker[]{firstType, secondType};
                    return new EmptyIntersectionTypeInfo(EmptyIntersectionTypeKind.MULTIPLE_CLASSES, kotlinTypeMarkerArray);
                }
                if (!TypeSystemInferenceExtensionContextContextualKt.isFinalClassConstructor(c2, firstTypeConstructor) && !TypeSystemInferenceExtensionContextContextualKt.isFinalClassConstructor(c2, secondTypeConstructor)) continue;
                kotlinTypeMarkerArray = new KotlinTypeMarker[]{firstType, secondType};
                possibleEmptyIntersectionKind = new EmptyIntersectionTypeInfo(EmptyIntersectionTypeKind.FINAL_CLASS_AND_INTERFACE, kotlinTypeMarkerArray);
            }
        }
        return possibleEmptyIntersectionKind;
    }

    private final boolean isSubtypeOfIgnoringArguments(RigidTypeMarker $this$isSubtypeOfIgnoringArguments, TypeCheckerState typeCheckerState, TypeConstructorMarker otherConstructorMarker) {
        return !((Collection)AbstractTypeChecker.INSTANCE.findCorrespondingSupertypes(typeCheckerState, $this$isSubtypeOfIgnoringArguments, otherConstructorMarker)).isEmpty();
    }

    private final boolean mayCauseEmptyIntersection(TypeSystemInferenceExtensionContext context2, KotlinTypeMarker type) {
        if (TypeSystemContextContextualKt.isStubType(context2, TypeSystemContextContextualKt.lowerBoundIfFlexible((TypeSystemContext)context2, type)) || TypeSystemContextContextualKt.isError((TypeSystemContext)context2, type)) {
            return false;
        }
        TypeConstructorMarker typeConstructor2 = TypeSystemContextContextualKt.typeConstructor((TypeSystemContext)context2, type);
        if (!TypeSystemContextContextualKt.isClassTypeConstructor(context2, typeConstructor2) && !TypeSystemContextContextualKt.isTypeParameterTypeConstructor(context2, typeConstructor2)) {
            return false;
        }
        return !TypeSystemContextContextualKt.isAnyConstructor(context2, typeConstructor2) && !TypeSystemContextContextualKt.isNothingConstructor(context2, typeConstructor2);
    }

    private static final KotlinTypeMarker computeEmptyIntersectionEmptiness$lambda$1(Lazy<? extends KotlinTypeMarker> $firstSubstitutedType$delegate) {
        Lazy<? extends KotlinTypeMarker> lazy = $firstSubstitutedType$delegate;
        return (KotlinTypeMarker)lazy.getValue();
    }

    private static final KotlinTypeMarker computeEmptyIntersectionEmptiness$lambda$0(TypeSystemInferenceExtensionContext $c, KotlinTypeMarker $firstType) {
        return TypeSystemInferenceExtensionContextContextualKt.eraseContainingTypeParameters($c, $firstType);
    }

    private static final List<KotlinTypeMarker> computeByHavingCommonSubtype$extractIntersectionComponentsIfNeeded(TypeSystemInferenceExtensionContext $c, KotlinTypeMarker type) {
        return TypeSystemContextContextualKt.typeConstructor((TypeSystemContext)$c, type) instanceof IntersectionTypeConstructorMarker ? CollectionsKt.toList((Iterable)TypeSystemContextContextualKt.supertypes($c, TypeSystemContextContextualKt.typeConstructor((TypeSystemContext)$c, type))) : CollectionsKt.listOf((Object)type);
    }

    private static final TypeCheckerState computeByHavingCommonSubtype$lambda$1(Lazy<? extends TypeCheckerState> $typeCheckerState$delegate) {
        Lazy<? extends TypeCheckerState> lazy = $typeCheckerState$delegate;
        return (TypeCheckerState)lazy.getValue();
    }

    private static final TypeCheckerState computeByHavingCommonSubtype$lambda$0(TypeSystemInferenceExtensionContext $c) {
        return TypeCheckerProviderContext.newTypeCheckerState$default($c, true, true, false, 4, null);
    }
}

