/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class ConstraintsUtil {
    @Nullable
    public static TypeVariable getFirstConflictingVariable(@NotNull ConstraintSystem constraintSystem) {
        if (constraintSystem == null) {
            ConstraintsUtil.$$$reportNull$$$0(0);
        }
        for (TypeVariable typeVariable : constraintSystem.getTypeVariables()) {
            TypeBounds constraints = constraintSystem.getTypeBounds(typeVariable);
            if (constraints.getValues().size() <= 1) continue;
            return typeVariable;
        }
        return null;
    }

    @NotNull
    public static Collection<TypeSubstitutor> getSubstitutorsForConflictingParameters(@NotNull ConstraintSystem constraintSystem) {
        TypeVariable firstConflictingVariable;
        if (constraintSystem == null) {
            ConstraintsUtil.$$$reportNull$$$0(1);
        }
        if ((firstConflictingVariable = ConstraintsUtil.getFirstConflictingVariable(constraintSystem)) == null) {
            List<TypeSubstitutor> list = Collections.emptyList();
            if (list == null) {
                ConstraintsUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        TypeParameterDescriptor firstConflictingParameter = firstConflictingVariable.getOriginalTypeParameter();
        Collection<KotlinType> conflictingTypes = constraintSystem.getTypeBounds(firstConflictingVariable).getValues();
        ArrayList substitutionContexts = Lists.newArrayList();
        for (KotlinType type : conflictingTypes) {
            LinkedHashMap<TypeConstructor, TypeProjectionImpl> linkedHashMap = Maps.newLinkedHashMap();
            linkedHashMap.put(firstConflictingParameter.getTypeConstructor(), new TypeProjectionImpl(type));
            substitutionContexts.add(linkedHashMap);
        }
        for (TypeVariable typeVariable : constraintSystem.getTypeVariables()) {
            if (typeVariable == firstConflictingVariable) continue;
            KotlinType kotlinType = ConstraintsUtil.getSafeValue(constraintSystem, typeVariable);
            for (Map map : substitutionContexts) {
                TypeProjectionImpl typeProjection = new TypeProjectionImpl(kotlinType);
                map.put(typeVariable.getOriginalTypeParameter().getTypeConstructor(), typeProjection);
            }
        }
        ArrayList<TypeSubstitutor> typeSubstitutors = new ArrayList<TypeSubstitutor>(substitutionContexts.size());
        for (Map map : substitutionContexts) {
            typeSubstitutors.add(TypeSubstitutor.create(map));
        }
        ArrayList<TypeSubstitutor> arrayList = typeSubstitutors;
        if (arrayList == null) {
            ConstraintsUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static KotlinType getSafeValue(@NotNull ConstraintSystem constraintSystem, @NotNull TypeVariable typeVariable) {
        KotlinType type;
        if (constraintSystem == null) {
            ConstraintsUtil.$$$reportNull$$$0(4);
        }
        if (typeVariable == null) {
            ConstraintsUtil.$$$reportNull$$$0(5);
        }
        if ((type = constraintSystem.getTypeBounds(typeVariable).getValue()) != null) {
            KotlinType kotlinType = type;
            if (kotlinType == null) {
                ConstraintsUtil.$$$reportNull$$$0(6);
            }
            return kotlinType;
        }
        KotlinType kotlinType = TypeIntersector.getUpperBoundsAsType(typeVariable.getOriginalTypeParameter());
        if (kotlinType == null) {
            ConstraintsUtil.$$$reportNull$$$0(7);
        }
        return kotlinType;
    }

    public static boolean checkUpperBoundIsSatisfied(@NotNull ConstraintSystem constraintSystem, @NotNull TypeParameterDescriptor typeParameter, @NotNull Call call2, boolean substituteOtherTypeParametersInBound) {
        TypeVariable typeVariable;
        KotlinType type;
        if (constraintSystem == null) {
            ConstraintsUtil.$$$reportNull$$$0(8);
        }
        if (typeParameter == null) {
            ConstraintsUtil.$$$reportNull$$$0(9);
        }
        if (call2 == null) {
            ConstraintsUtil.$$$reportNull$$$0(10);
        }
        if ((type = constraintSystem.getTypeBounds(typeVariable = ConstraintSystemUtilsKt.descriptorToVariable(constraintSystem, TypeVariableKt.toHandle(call2), typeParameter)).getValue()) == null) {
            return true;
        }
        List typeParametersUsedInSystem = CollectionsKt.map(constraintSystem.getTypeVariables(), TypeVariable::getOriginalTypeParameter);
        for (KotlinType upperBound : typeParameter.getUpperBounds()) {
            if (!substituteOtherTypeParametersInBound && TypeUtils.dependsOnTypeParameters(upperBound, typeParametersUsedInSystem)) continue;
            KotlinType substitutedUpperBound = constraintSystem.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
            assert (substitutedUpperBound != null) : "We wanted to substitute projections as a result for " + typeParameter;
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(type, substitutedUpperBound)) continue;
            return false;
        }
        return true;
    }

    public static String getDebugMessageForStatus(@NotNull ConstraintSystemStatus status2) {
        if (status2 == null) {
            ConstraintsUtil.$$$reportNull$$$0(11);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Method> interestingMethods = Lists.newArrayList();
        for (Method method : status2.getClass().getMethods()) {
            boolean isInteresting;
            String name2 = method.getName();
            boolean bl = isInteresting = name2.startsWith("is") || name2.startsWith("has") && !name2.equals("hashCode");
            if (method.getParameterTypes().length != 0 || !isInteresting) continue;
            interestingMethods.add(method);
        }
        interestingMethods.sort(Comparator.comparing(Method::getName));
        Iterator iterator2 = interestingMethods.iterator();
        while (iterator2.hasNext()) {
            Method method = (Method)iterator2.next();
            try {
                sb.append("-").append(method.getName()).append(": ").append(method.invoke((Object)status2, new Object[0]));
                if (!iterator2.hasNext()) continue;
                sb.append("\n");
            }
            catch (IllegalAccessException | InvocationTargetException e2) {
                sb.append(e2.getMessage());
            }
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintSystem";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVariable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorsForConflictingParameters";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSafeValue";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFirstConflictingVariable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorsForConflictingParameters";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSafeValue";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkUpperBoundIsSatisfied";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDebugMessageForStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

