/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.validation.IrFileValidator;
import org.jetbrains.kotlin.ir.validation.IrValidationError;
import org.jetbrains.kotlin.ir.validation.IrValidatorConfig;
import org.jetbrains.kotlin.ir.validation.checkers.context.CheckerContext;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/validation/IrValidator;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "validatorConfig", "Lorg/jetbrains/kotlin/ir/validation/IrValidatorConfig;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "reportError", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/validation/IrValidationError;", "", "<init>", "(Lorg/jetbrains/kotlin/ir/validation/IrValidatorConfig;Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lkotlin/jvm/functions/Function1;)V", "getValidatorConfig", "()Lorg/jetbrains/kotlin/ir/validation/IrValidatorConfig;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getReportError", "()Lkotlin/jvm/functions/Function1;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitFile", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "ir.validation"})
final class IrValidator
extends IrVisitorVoid {
    @NotNull
    private final IrValidatorConfig validatorConfig;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Function1<IrValidationError, Unit> reportError;

    public IrValidator(@NotNull IrValidatorConfig validatorConfig, @NotNull IrBuiltIns irBuiltIns, @NotNull Function1<? super IrValidationError, Unit> reportError) {
        Intrinsics.checkNotNullParameter((Object)validatorConfig, (String)"validatorConfig");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter(reportError, (String)"reportError");
        this.validatorConfig = validatorConfig;
        this.irBuiltIns = irBuiltIns;
        this.reportError = reportError;
    }

    @NotNull
    public final IrValidatorConfig getValidatorConfig() {
        return this.validatorConfig;
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final Function1<IrValidationError, Unit> getReportError() {
        return this.reportError;
    }

    @NotNull
    public Void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IllegalStateException("IR validation must start from files, modules, or declarations");
    }

    @Override
    public void visitFile(@NotNull IrFile declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        CheckerContext context2 = new CheckerContext(this.irBuiltIns, declaration, this.reportError);
        IrFileValidator fileValidator = new IrFileValidator(this.validatorConfig, context2);
        IrVisitorsKt.acceptVoid((IrElement)declaration, fileValidator);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrVisitorsKt.acceptChildrenVoid((IrElement)declaration, this);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        CheckerContext context2 = new CheckerContext(this.irBuiltIns, IrUtilsKt.getFile(declaration), this.reportError);
        IrFileValidator fileValidator = new IrFileValidator(this.validatorConfig, context2);
        IrVisitorsKt.acceptVoid((IrElement)declaration, fileValidator);
    }
}

