/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.ProtoDataProvider;
import org.jetbrains.kotlin.incremental.TranslationResultValueExternalizer;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.AbstractBasicMap;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/incremental/TranslationResultMap;", "Lorg/jetbrains/kotlin/incremental/storage/AbstractBasicMap;", "Ljava/io/File;", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "storageFile", "protoData", "Lorg/jetbrains/kotlin/incremental/ProtoDataProvider;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/ProtoDataProvider;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "dumpValue", "", "value", "put", "", "sourceFile", "newMetadata", "", "newBinaryAst", "newInlineData", "remove", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "kotlin-build-common"})
final class TranslationResultMap
extends AbstractBasicMap<File, TranslationResultValue> {
    @NotNull
    private final ProtoDataProvider protoData;

    public TranslationResultMap(@NotNull File storageFile, @NotNull ProtoDataProvider protoData, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)protoData, (String)"protoData");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        super(storageFile, icContext.getFileDescriptorForSourceFiles(), TranslationResultValueExternalizer.INSTANCE, icContext);
        this.protoData = protoData;
    }

    @Override
    @NotNull
    public String dumpValue(@NotNull TranslationResultValue value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return "Metadata: " + IncrementalJvmCacheKt.md5(value2.getMetadata()) + ", Binary AST: " + IncrementalJvmCacheKt.md5(value2.getBinaryAst()) + ", InlineData: " + IncrementalJvmCacheKt.md5(value2.getInlineData());
    }

    public final synchronized void put(@NotNull File sourceFile, @NotNull byte[] newMetadata, @NotNull byte[] newBinaryAst, @NotNull byte[] newInlineData) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)newMetadata, (String)"newMetadata");
        Intrinsics.checkNotNullParameter((Object)newBinaryAst, (String)"newBinaryAst");
        Intrinsics.checkNotNullParameter((Object)newInlineData, (String)"newInlineData");
        this.set(sourceFile, new TranslationResultValue(newMetadata, newBinaryAst, newInlineData));
    }

    public final synchronized void remove(@NotNull File sourceFile, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Object VALUE = this.get(sourceFile);
        Intrinsics.checkNotNull(VALUE);
        byte[] protoBytes = ((TranslationResultValue)VALUE).getMetadata();
        Map<ClassId, ProtoData> protoMap = this.protoData.invoke(sourceFile, protoBytes);
        Iterator<Map.Entry<ClassId, ProtoData>> iterator2 = protoMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            ProtoData protoData = iterator2.next().getValue();
            ChangesCollector.collectProtoChanges$default(changesCollector, protoData, null, false, null, 12, null);
        }
        this.remove(sourceFile);
    }
}

