/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRendererForDebugInfo;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.types.AbstractTypeApproximator;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.model.CapturedTypeMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0014J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeTypeApproximator;", "Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "inferenceContext", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "approximateToSuperType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "conf", "Lorg/jetbrains/kotlin/types/TypeApproximatorConfiguration;", "approximateToSubType", "renderForDebugInfo", "", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "fastPathSkipApproximation", "", "mightNeedApproximation", "providers"})
@SourceDebugExtension(value={"SMAP\nConeTypeApproximator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeTypeApproximator.kt\norg/jetbrains/kotlin/fir/types/ConeTypeApproximator\n+ 2 ConeTypes.kt\norg/jetbrains/kotlin/fir/types/ConeTypesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n50#2:73\n50#2:74\n50#2:75\n50#2:77\n1#3:76\n*S KotlinDebug\n*F\n+ 1 ConeTypeApproximator.kt\norg/jetbrains/kotlin/fir/types/ConeTypeApproximator\n*L\n19#1:73\n24#1:74\n28#1:75\n60#1:77\n*E\n"})
public final class ConeTypeApproximator
extends AbstractTypeApproximator {
    public ConeTypeApproximator(@NotNull ConeInferenceContext inferenceContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)inferenceContext, (String)"inferenceContext");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        super(inferenceContext, languageVersionSettings);
    }

    @Nullable
    public final ConeKotlinType approximateToSuperType(@NotNull ConeKotlinType type, @NotNull TypeApproximatorConfiguration conf) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        if (this.fastPathSkipApproximation(type, conf)) {
            return null;
        }
        KotlinTypeMarker kotlinTypeMarker = super.approximateToSuperType(type, conf, null);
        if (kotlinTypeMarker != null) {
            KotlinTypeMarker $this$asCone$iv = kotlinTypeMarker;
            boolean $i$f$asCone = false;
            coneKotlinType = (ConeKotlinType)$this$asCone$iv;
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    @Nullable
    public final ConeKotlinType approximateToSubType(@NotNull ConeKotlinType type, @NotNull TypeApproximatorConfiguration conf) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        if (this.fastPathSkipApproximation(type, conf)) {
            return null;
        }
        KotlinTypeMarker kotlinTypeMarker = super.approximateToSubType(type, conf, null);
        if (kotlinTypeMarker != null) {
            KotlinTypeMarker $this$asCone$iv = kotlinTypeMarker;
            boolean $i$f$asCone = false;
            coneKotlinType = (ConeKotlinType)$this$asCone$iv;
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    @Override
    @NotNull
    protected String renderForDebugInfo(@NotNull KotlinTypeMarker $this$renderForDebugInfo) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$renderForDebugInfo, (String)"<this>");
        StringBuilder $this$renderForDebugInfo_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        KotlinTypeMarker $this$asCone$iv = $this$renderForDebugInfo;
        boolean $i$f$asCone = false;
        ConeTypeRenderer.render$default(new ConeTypeRendererForDebugInfo($this$renderForDebugInfo_u24lambda_u240, true), (ConeKotlinType)$this$asCone$iv, null, 2, null);
        return stringBuilder.toString();
    }

    private final boolean fastPathSkipApproximation(ConeKotlinType $this$fastPathSkipApproximation, TypeApproximatorConfiguration conf) {
        if ($this$fastPathSkipApproximation instanceof ConeClassLikeType && $this$fastPathSkipApproximation.getTypeArguments().length == 0) {
            ConeClassLikeLookupTag it = ((ConeClassLikeType)$this$fastPathSkipApproximation).getLookupTag();
            boolean bl = false;
            boolean bl2 = !this.isLocalType(it) && !this.isAnonymous(it);
            if (bl2) {
                return true;
            }
        }
        if (!this.getLanguageVersionSettings().supportsFeature(LanguageFeature.AvoidApproximationOfRecursiveCapturedTypesWithNoReason)) {
            return false;
        }
        if (!(conf instanceof TypeApproximatorConfiguration.AbstractCapturedTypesAndILTApproximation)) {
            return false;
        }
        return !this.contains($this$fastPathSkipApproximation, (Function1<? super KotlinTypeMarker, Boolean>)((Function1)arg_0 -> ConeTypeApproximator.fastPathSkipApproximation$lambda$1(this, conf, arg_0)));
    }

    private final boolean mightNeedApproximation(ConeKotlinType type, TypeApproximatorConfiguration conf) {
        ConeKotlinType coneKotlinType = type;
        return coneKotlinType instanceof ConeIntegerLiteralType ? true : (coneKotlinType instanceof ConeCapturedType ? conf.shouldApproximateCapturedType(this, (CapturedTypeMarker)((Object)type)) : false);
    }

    private static final boolean fastPathSkipApproximation$lambda$1(ConeTypeApproximator this$0, TypeApproximatorConfiguration $conf, KotlinTypeMarker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KotlinTypeMarker $this$asCone$iv = it;
        boolean $i$f$asCone = false;
        return this$0.mightNeedApproximation((ConeKotlinType)$this$asCone$iv, $conf);
    }
}

