/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.builder.FirPropertyAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.ContextSensitiveResolutionKt;
import org.jetbrains.kotlin.fir.resolve.FirResolvedSymbolOrigin;
import org.jetbrains.kotlin.fir.resolve.ResolutionMode;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.FirErrorReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeHiddenCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0004\u001a\f\u0010\t\u001a\u00020\b*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"runContextSensitiveResolutionForPropertyAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "originalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "shouldBeResolvedInContextSensitiveMode", "", "meansNoAvailableCandidate", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "resolve"})
@SourceDebugExtension(value={"SMAP\nContextSensitiveResolutionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextSensitiveResolutionUtils.kt\norg/jetbrains/kotlin/fir/resolve/ContextSensitiveResolutionUtilsKt\n+ 2 FirPropertyAccessExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirPropertyAccessExpressionBuilderKt\n+ 3 FirSimpleNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirSimpleNamedReferenceBuilderKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n65#2:106\n41#3:107\n1786#4,3:108\n*S KotlinDebug\n*F\n+ 1 ContextSensitiveResolutionUtils.kt\norg/jetbrains/kotlin/fir/resolve/ContextSensitiveResolutionUtilsKt\n*L\n40#1:106\n43#1:107\n100#1:108,3\n*E\n"})
public final class ContextSensitiveResolutionUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FirExpression runContextSensitiveResolutionForPropertyAccess(@NotNull BodyResolveComponents $this$runContextSensitiveResolutionForPropertyAccess, @NotNull FirPropertyAccessExpression originalExpression2, @NotNull ConeKotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)$this$runContextSensitiveResolutionForPropertyAccess, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)originalExpression2, (String)"originalExpression");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        for (FirRegularClassSymbol representativeClass : ContextSensitiveResolutionKt.getParentChainForContextSensitiveResolutionOfExpressions(expectedType, $this$runContextSensitiveResolutionForPropertyAccess.getSession())) {
            boolean shouldTakeNewExpression;
            boolean bl;
            FirExpression newExpression;
            void $this$runContextSensitiveResolutionForPropertyAccess_u24lambda_u240_u240;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
            FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
            KtSourceElement ktSourceElement = originalExpression2.getSource();
            FirResolvedQualifier additionalQualifier = ResolveUtilsKt.toImplicitResolvedQualifierReceiver(representativeClass, $this$runContextSensitiveResolutionForPropertyAccess, ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.QualifierForContextSensitiveResolution.INSTANCE, null, 2, null) : null);
            boolean $i$f$buildPropertyAccessExpression = false;
            FirPropertyAccessExpressionBuilder $this$runContextSensitiveResolutionForPropertyAccess_u24lambda_u240 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
            boolean bl2 = false;
            $this$runContextSensitiveResolutionForPropertyAccess_u24lambda_u240.setExplicitReceiver(additionalQualifier);
            $this$runContextSensitiveResolutionForPropertyAccess_u24lambda_u240.setSource(originalExpression2.getSource());
            boolean $i$f$buildSimpleNamedReference = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$runContextSensitiveResolutionForPropertyAccess_u24lambda_u240;
            boolean bl3 = false;
            $this$runContextSensitiveResolutionForPropertyAccess_u24lambda_u240_u240.setSource(originalExpression2.getCalleeReference().getSource());
            $this$runContextSensitiveResolutionForPropertyAccess_u24lambda_u240_u240.setName(originalExpression2.getCalleeReference().getName());
            firPropertyAccessExpressionBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
            FirPropertyAccessExpression newAccess = firPropertyAccessExpressionBuilder.build();
            FirExpression firExpression = newExpression = $this$runContextSensitiveResolutionForPropertyAccess.getCallResolver().resolveVariableAccessAndSelectCandidate(newAccess, false, false, newAccess, ResolutionMode.ContextIndependent.INSTANCE);
            if (firExpression instanceof FirPropertyAccessExpression) {
                boolean shouldTake;
                FirNamedReference newCalleeReference = ((FirPropertyAccessExpression)newExpression).getCalleeReference();
                boolean bl4 = shouldTake = newCalleeReference instanceof FirResolvedNamedReference && !(newCalleeReference instanceof FirResolvedErrorReference);
                if (shouldTake) {
                    ((FirResolvedNamedReference)newCalleeReference).replaceResolvedSymbolOrigin(FirResolvedSymbolOrigin.ContextSensitive);
                }
                bl = shouldTake;
            } else if (firExpression instanceof FirResolvedQualifier) {
                ((FirResolvedQualifier)newExpression).replaceResolvedSymbolOrigin(FirResolvedSymbolOrigin.ContextSensitive);
                bl = true;
            } else {
                bl = false;
            }
            if (!(shouldTakeNewExpression = bl)) continue;
            return newExpression;
        }
        return null;
    }

    public static final boolean shouldBeResolvedInContextSensitiveMode(@NotNull FirPropertyAccessExpression $this$shouldBeResolvedInContextSensitiveMode) {
        ConeDiagnostic coneDiagnostic;
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeResolvedInContextSensitiveMode, (String)"<this>");
        FirNamedReference calleeReference = $this$shouldBeResolvedInContextSensitiveMode.getCalleeReference();
        if (calleeReference instanceof FirErrorNamedReference) {
            coneDiagnostic = ((FirErrorNamedReference)calleeReference).getDiagnostic();
        } else if (calleeReference instanceof FirErrorReferenceWithCandidate) {
            coneDiagnostic = ((FirErrorReferenceWithCandidate)calleeReference).getDiagnostic();
        } else if (calleeReference instanceof FirResolvedErrorReference) {
            coneDiagnostic = ((FirResolvedErrorReference)calleeReference).getDiagnostic();
        } else {
            return false;
        }
        ConeDiagnostic diagnostic = coneDiagnostic;
        if ($this$shouldBeResolvedInContextSensitiveMode.getExplicitReceiver() != null) {
            return false;
        }
        return ContextSensitiveResolutionUtilsKt.meansNoAvailableCandidate(diagnostic);
    }

    private static final boolean meansNoAvailableCandidate(ConeDiagnostic $this$meansNoAvailableCandidate) {
        boolean bl;
        block7: {
            ConeDiagnostic coneDiagnostic = $this$meansNoAvailableCandidate;
            if (coneDiagnostic instanceof ConeUnresolvedError || coneDiagnostic instanceof ConeVisibilityError || coneDiagnostic instanceof ConeHiddenCandidateError) {
                bl = true;
            } else if (coneDiagnostic instanceof ConeAmbiguityError) {
                Iterable $this$all$iv = ((ConeAmbiguityError)$this$meansNoAvailableCandidate).getCandidates();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        AbstractCandidate it = (AbstractCandidate)element$iv;
                        boolean bl2 = false;
                        if (it.getApplicability() == CandidateApplicability.HIDDEN || it.getApplicability() == CandidateApplicability.K2_VISIBILITY_ERROR) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }
}

