/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirNonSuppressibleErrorNamesKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.ConstantArgumentKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstChecksKt;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.RequireKotlinConstants;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u00020\u000fR\u00020\u0011j\u0006\u0010\u0010\u001a\u00020\u000fj\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0014J7\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u00020\u0011R\u00020\u000fj\u0006\u0010\u0012\u001a\u00020\u0011j\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001aJ/\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\u0017H\u0002R\u00020\u000fR\u00020\u0011j\u0006\u0010\u0010\u001a\u00020\u000fj\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001dJ7\u0010\u001e\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020!H\u0002R\u00020\u000fR\u00020\u0011j\u0006\u0010\u0010\u001a\u00020\u000fj\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\"JM\u0010#\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170'H\u0002R\u00020\u000fR\u00020\u0011j\u0006\u0010\u0010\u001a\u00020\u000fj\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010(J-\u0010)\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020*H\u0002R\u00020\u000fR\u00020\u0011j\u0006\u0010\u0010\u001a\u00020\u000fj\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010+J-\u0010,\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0002H\u0002R\u00020\u000fR\u00020\u0011j\u0006\u0010\u0010\u001a\u00020\u000fj\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0014JC\u0010-\u001a\u00020\u000e2\b\u0010.\u001a\u0004\u0018\u00010/2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170'H\u0002R\u00020\u0011R\u00020\u000fj\u0006\u0010\u0012\u001a\u00020\u0011j\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u00100J9\u00101\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002R\u00020\u0011R\u00020\u000fj\u0006\u0010\u0012\u001a\u00020\u0011j\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u00102R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "<init>", "()V", "versionArgumentName", "Lorg/jetbrains/kotlin/name/Name;", "deprecatedSinceKotlinFqName", "Lorg/jetbrains/kotlin/name/FqName;", "sinceKotlinFqName", "annotationFqNamesWithVersion", "", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;)V", "checkAnnotationArgumentWithSubElements", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "parseVersionExpressionOrReport", "Lorg/jetbrains/kotlin/config/ApiVersion;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/config/ApiVersion;", "checkAnnotationsWithVersion", "fqName", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)V", "checkDeprecatedSinceKotlin", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "argumentMapping", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/name/FqName;Ljava/util/Map;)V", "checkAnnotationsInsideAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirCall;)V", "checkNotAClass", "checkErrorSuppression", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/name/ClassId;Ljava/util/Map;)V", "checkContextFunctionTypeParams", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/name/ClassId;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationExpressionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationExpressionChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1#2:270\n*E\n"})
public final class FirAnnotationExpressionChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirAnnotationExpressionChecker INSTANCE = new FirAnnotationExpressionChecker();
    @NotNull
    private static final Name versionArgumentName;
    @NotNull
    private static final FqName deprecatedSinceKotlinFqName;
    @NotNull
    private static final FqName sinceKotlinFqName;
    @NotNull
    private static final Set<FqName> annotationFqNamesWithVersion;

    private FirAnnotationExpressionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirAnnotationCall expression2) {
        ClassId annotationClassId;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Map<Name, FirExpression> argumentMapping2 = expression2.getArgumentMapping().getMapping();
        ClassId classId = annotationClassId = FirAnnotationUtilsKt.toAnnotationClassId(expression2, context2.getSession());
        FqName fqName = classId != null ? classId.asSingleFqName() : null;
        for (FirExpression arg : argumentMapping2.values()) {
            FirExpression argExpression;
            KtDiagnosticFactory0 ktDiagnosticFactory0;
            FirExpression firExpression = arg instanceof FirErrorExpression ? (FirErrorExpression)arg : null;
            if (firExpression == null || (firExpression = ((FirErrorExpression)firExpression).getExpression()) == null) {
                firExpression = arg;
            }
            if ((ktDiagnosticFactory0 = this.checkAnnotationArgumentWithSubElements(reporter, context2, argExpression = firExpression, context2.getSession())) == null) continue;
            KtDiagnosticFactory0 it = ktDiagnosticFactory0;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)argExpression.getSource(), it, null, 8, null);
        }
        this.checkAnnotationsWithVersion(context2, reporter, fqName, expression2);
        this.checkDeprecatedSinceKotlin(context2, reporter, expression2.getSource(), fqName, argumentMapping2);
        this.checkAnnotationsInsideAnnotationCall(context2, reporter, expression2);
        this.checkNotAClass(context2, reporter, expression2);
        this.checkErrorSuppression(reporter, context2, annotationClassId, argumentMapping2);
        this.checkContextFunctionTypeParams(reporter, context2, expression2.getSource(), annotationClassId);
    }

    private final KtDiagnosticFactory0 checkAnnotationArgumentWithSubElements(DiagnosticReporter reporter, CheckerContext context2, FirExpression expression2, FirSession session) {
        FirExpression firExpression = expression2;
        if (firExpression instanceof FirArrayLiteral) {
            return FirAnnotationExpressionChecker.checkAnnotationArgumentWithSubElements$checkArgumentList(reporter, context2, session, ((FirArrayLiteral)expression2).getArgumentList());
        }
        if (firExpression instanceof FirVarargArgumentsExpression) {
            for (FirExpression arg : ((FirVarargArgumentsExpression)expression2).getArguments()) {
                FirExpression unwrappedArg = FirExpressionUtilKt.unwrapArgument(arg);
                KtDiagnosticFactory0 ktDiagnosticFactory0 = this.checkAnnotationArgumentWithSubElements(reporter, context2, unwrappedArg, session);
                if (ktDiagnosticFactory0 == null) continue;
                KtDiagnosticFactory0 it = ktDiagnosticFactory0;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)unwrappedArg.getSource(), it, null, 8, null);
            }
        } else {
            KtDiagnosticFactory0 ktDiagnosticFactory0;
            switch (WhenMappings.$EnumSwitchMapping$0[FirConstChecksKt.computeConstantExpressionKind(expression2, session, true).ordinal()]) {
                case 1: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_CONST();
                    break;
                }
                case 2: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_ENUM_CONST();
                    break;
                }
                case 3: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL();
                    break;
                }
                case 4: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR();
                    break;
                }
                case 5: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getNON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION();
                    break;
                }
                case 6: 
                case 7: {
                    if (expression2 instanceof FirFunctionCall) {
                        ktDiagnosticFactory0 = FirAnnotationExpressionChecker.checkAnnotationArgumentWithSubElements$checkArgumentList(reporter, context2, session, ((FirFunctionCall)expression2).getArgumentList());
                        break;
                    }
                    ktDiagnosticFactory0 = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return ktDiagnosticFactory0;
        }
        return null;
    }

    private final ApiVersion parseVersionExpressionOrReport(CheckerContext context2, DiagnosticReporter reporter, FirExpression expression2) {
        FirLiteralExpression firLiteralExpression = expression2 instanceof FirLiteralExpression ? (FirLiteralExpression)expression2 : null;
        if (firLiteralExpression == null) {
            return null;
        }
        FirLiteralExpression constantExpression = firLiteralExpression;
        Object object = constantExpression.getValue();
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return null;
        }
        String stringValue = string;
        CharSequence charSequence = stringValue;
        if (!RequireKotlinConstants.INSTANCE.getVERSION_REGEX().matches(charSequence)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirLiteralExpression)expression2).getSource(), FirErrors.INSTANCE.getILLEGAL_KOTLIN_VERSION_STRING_VALUE(), null, 8, null);
            return null;
        }
        ApiVersion version2 = ApiVersion.Companion.parse(stringValue);
        if (version2 == null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirLiteralExpression)expression2).getSource(), FirErrors.INSTANCE.getILLEGAL_KOTLIN_VERSION_STRING_VALUE(), null, 8, null);
        }
        return version2;
    }

    private final void checkAnnotationsWithVersion(CheckerContext context2, DiagnosticReporter reporter, FqName fqName, FirAnnotation annotation) {
        ApiVersion specified;
        if (!CollectionsKt.contains((Iterable)annotationFqNamesWithVersion, (Object)fqName)) {
            return;
        }
        FirExpression firExpression = FirAnnotationUtilsKt.findArgumentByName$default(annotation, versionArgumentName, false, 2, null);
        if (firExpression == null) {
            return;
        }
        FirExpression versionExpression = firExpression;
        ApiVersion apiVersion = this.parseVersionExpressionOrReport(context2, reporter, versionExpression);
        if (apiVersion == null) {
            return;
        }
        ApiVersion version2 = apiVersion;
        if (Intrinsics.areEqual((Object)fqName, (Object)sinceKotlinFqName) && version2.compareTo(specified = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).getApiVersion()) > 0) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)versionExpression.getSource(), FirErrors.INSTANCE.getNEWER_VERSION_IN_SINCE_KOTLIN(), (Object)specified.getVersionString(), null, 16, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDeprecatedSinceKotlin(CheckerContext context, DiagnosticReporter reporter, KtSourceElement source, FqName fqName, Map<Name, ? extends FirExpression> argumentMapping) {
        if (!Intrinsics.areEqual((Object)fqName, (Object)FirAnnotationExpressionChecker.deprecatedSinceKotlinFqName)) {
            return;
        }
        if (argumentMapping.size() == 0) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITHOUT_ARGUMENTS(), null, 8, null);
        }
        warningSince = null;
        errorSince = null;
        hiddenSince = null;
        for (Map.Entry<Name, ? extends FirExpression> var10_11 : argumentMapping.entrySet()) {
            block28: {
                name = var10_11.getKey();
                argument = var10_11.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)name.getIdentifier(), (String)"getIdentifier(...)");
                switch (identifier.hashCode()) {
                    case -855220304: {
                        if (!identifier.equals("hiddenSince")) {
                            break;
                        }
                        ** GOTO lbl23
                    }
                    case -2027506434: {
                        if (!identifier.equals("warningSince")) {
                            break;
                        }
                        ** GOTO lbl23
                    }
                    case 1624782354: {
                        if (!identifier.equals("errorSince")) break;
lbl23:
                        // 3 sources

                        if ((version = this.parseVersionExpressionOrReport(context, reporter, argument)) == null) break;
                        var15_16 = identifier;
                        tmp = -1;
                        switch (var15_16.hashCode()) {
                            case -855220304: {
                                if (var15_16.equals("hiddenSince")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case -2027506434: {
                                if (var15_16.equals("warningSince")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 1624782354: {
                                if (var15_16.equals("errorSince")) {
                                    tmp = 3;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 2: {
                                warningSince = version;
                                break block28;
                            }
                            case 3: {
                                errorSince = version;
                                break block28;
                            }
                            case 1: {
                                hiddenSince = version;
                            }
                        }
                    }
                }
            }
        }
        isReportDeprecatedSinceKotlinWithUnorderedVersions = false;
        if (warningSince != null) {
            if (errorSince != null) {
                v0 = isReportDeprecatedSinceKotlinWithUnorderedVersions = warningSince.compareTo(errorSince) > 0;
            }
            if (hiddenSince != null && !isReportDeprecatedSinceKotlinWithUnorderedVersions) {
                v1 = isReportDeprecatedSinceKotlinWithUnorderedVersions = warningSince.compareTo(hiddenSince) > 0;
            }
        }
        if (errorSince != null && hiddenSince != null && !isReportDeprecatedSinceKotlinWithUnorderedVersions) {
            v2 = isReportDeprecatedSinceKotlinWithUnorderedVersions = errorSince.compareTo(hiddenSince) > 0;
        }
        if (isReportDeprecatedSinceKotlinWithUnorderedVersions) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITH_UNORDERED_VERSIONS(), null, 8, null);
        }
    }

    private final void checkAnnotationsInsideAnnotationCall(CheckerContext context2, DiagnosticReporter reporter, FirCall expression2) {
        List<FirExpression> args = expression2.getArgumentList().getArguments();
        for (FirExpression arg : args) {
            FirExpression unwrapped = FirExpressionUtilKt.unwrapArgument(arg);
            FirExpression unwrappedErrorExpression = FirExpressionUtilKt.unwrapErrorExpression(unwrapped);
            KtDiagnosticFactory0 errorFactory2 = unwrapped instanceof FirErrorExpression && ((FirErrorExpression)unwrapped).getExpression() == null ? FirErrors.INSTANCE.getANNOTATION_USED_AS_ANNOTATION_ARGUMENT() : FirErrors.INSTANCE.getANNOTATION_ON_ANNOTATION_ARGUMENT();
            for (FirAnnotation ann : unwrappedErrorExpression.getAnnotations()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)ann.getSource(), errorFactory2, null, 8, null);
            }
            if (!(unwrappedErrorExpression instanceof FirArrayLiteral)) continue;
            this.checkAnnotationsInsideAnnotationCall(context2, reporter, (FirCall)((Object)unwrappedErrorExpression));
        }
    }

    private final void checkNotAClass(CheckerContext context2, DiagnosticReporter reporter, FirAnnotationCall expression2) {
        FirTypeRef annotationTypeRef = expression2.getAnnotationTypeRef();
        if (expression2.getCalleeReference() instanceof FirErrorNamedReference && !(annotationTypeRef instanceof FirErrorTypeRef) && !(FirTypeUtilsKt.getConeType(annotationTypeRef) instanceof ConeClassLikeType)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotationTypeRef.getSource(), FirErrors.INSTANCE.getNOT_A_CLASS(), null, 8, null);
        }
    }

    private final void checkErrorSuppression(DiagnosticReporter reporter, CheckerContext context2, ClassId annotationClassId, Map<Name, ? extends FirExpression> argumentMapping2) {
        if (context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getDontWarnOnErrorSuppression()).booleanValue()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)annotationClassId, (Object)StandardClassIds.Annotations.INSTANCE.getSuppress())) {
            return;
        }
        Object object = argumentMapping2.get(StandardClassIds.Annotations.ParameterNames.INSTANCE.getSuppressNames());
        if (object == null || (object = FirAnnotationUtilsKt.unwrapVarargValue((FirExpression)object)) == null) {
            return;
        }
        Object nameExpressions = object;
        Iterator iterator2 = nameExpressions.iterator();
        while (iterator2.hasNext()) {
            String string;
            String name2;
            FirExpression nameExpression = (FirExpression)iterator2.next();
            FirLiteralExpression firLiteralExpression = nameExpression instanceof FirLiteralExpression ? (FirLiteralExpression)nameExpression : null;
            Object object2 = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
            if ((object2 instanceof String ? (String)object2 : null) == null) continue;
            name2 = name2;
            object2 = name2;
            if (FirNonSuppressibleErrorNamesKt.getFIR_NON_SUPPRESSIBLE_ERROR_NAMES().contains(object2)) {
                string = name2;
            } else {
                if (!Intrinsics.areEqual((Object)object2, (Object)"errors")) continue;
                string = "all errors";
            }
            String parameter = string;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirLiteralExpression)nameExpression).getSource(), FirErrors.INSTANCE.getERROR_SUPPRESSION(), (Object)parameter, null, 16, null);
        }
    }

    private final void checkContextFunctionTypeParams(DiagnosticReporter reporter, CheckerContext context2, KtSourceElement source, ClassId annotationClassId) {
        if (!Intrinsics.areEqual((Object)annotationClassId, (Object)StandardClassIds.Annotations.INSTANCE.getContextFunctionTypeParams())) {
            return;
        }
        FirHelpersKt.requireFeatureSupport$default(context2, reporter, source, LanguageFeature.ContextReceivers, null, 8, null);
    }

    private static final KtDiagnosticFactory0 checkAnnotationArgumentWithSubElements$checkArgumentList(DiagnosticReporter $reporter, CheckerContext $context, FirSession $session, FirArgumentList args) {
        boolean usedNonConst = false;
        for (FirExpression arg : args.getArguments()) {
            KtSourceElement sourceForReport = arg.getSource();
            KtDiagnosticFactory0 err = INSTANCE.checkAnnotationArgumentWithSubElements($reporter, $context, arg, $session);
            if (err == null) continue;
            if (!Intrinsics.areEqual((Object)err, (Object)FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL())) {
                usedNonConst = true;
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)sourceForReport, err, null, 8, null);
        }
        return usedNonConst ? FirErrors.INSTANCE.getNON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION() : null;
    }

    static {
        Name name2 = Name.identifier("version");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        versionArgumentName = name2;
        deprecatedSinceKotlinFqName = new FqName("kotlin.DeprecatedSinceKotlin");
        sinceKotlinFqName = new FqName("kotlin.SinceKotlin");
        Object[] objectArray = new FqName[]{RequireKotlinConstants.INSTANCE.getFQ_NAME(), sinceKotlinFqName};
        annotationFqNamesWithVersion = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstantArgumentKind.values().length];
            try {
                nArray[ConstantArgumentKind.NOT_CONST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.ENUM_NOT_CONST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.NOT_KCLASS_LITERAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.NOT_CONST_VAL_IN_CONST_EXPRESSION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.VALID_CONST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.RESOLUTION_ERROR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

