/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.system;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CpuArch {
    X86(32),
    X86_64(64),
    ARM32(32),
    ARM64(64),
    OTHER(0),
    UNKNOWN(0);

    public final int width;
    public static final CpuArch CURRENT;

    private CpuArch(int width) {
        if (width == 0) {
            try {
                width = Integer.parseInt(System.getProperty("sun.arch.data.model", "32"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.width = width;
    }

    @NotNull
    public static CpuArch fromString(@Nullable String arch) {
        if ("x86_64".equals(arch) || "amd64".equals(arch)) {
            CpuArch cpuArch = X86_64;
            if (cpuArch == null) {
                CpuArch.$$$reportNull$$$0(0);
            }
            return cpuArch;
        }
        if ("i386".equals(arch) || "x86".equals(arch)) {
            CpuArch cpuArch = X86;
            if (cpuArch == null) {
                CpuArch.$$$reportNull$$$0(1);
            }
            return cpuArch;
        }
        if ("aarch64".equals(arch) || "arm64".equals(arch)) {
            CpuArch cpuArch = ARM64;
            if (cpuArch == null) {
                CpuArch.$$$reportNull$$$0(2);
            }
            return cpuArch;
        }
        CpuArch cpuArch = arch == null || arch.trim().isEmpty() ? UNKNOWN : OTHER;
        if (cpuArch == null) {
            CpuArch.$$$reportNull$$$0(3);
        }
        return cpuArch;
    }

    public static boolean isIntel64() {
        return CURRENT == X86_64;
    }

    public static boolean isArm64() {
        return CURRENT == ARM64;
    }

    public static boolean is32Bit() {
        return CpuArch.CURRENT.width == 32;
    }

    static {
        CURRENT = CpuArch.fromString(System.getProperty("os.arch"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/system/CpuArch", "fromString"));
    }
}

