/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.web.js;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationException;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.js.IcCachesArtifacts;
import org.jetbrains.kotlin.cli.js.Ir2JsTransformer;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.pipeline.web.JsBackendPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.web.WebBackendPipelinePhase;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.SourceMapsInfo;
import org.jetbrains.kotlin.ir.backend.js.ic.JsExecutableProducer;
import org.jetbrains.kotlin.ir.backend.js.ic.JsModuleArtifact;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CompilationOutputs;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CompilationOutputsBuilt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeysKt;
import org.jetbrains.kotlin.js.config.WebArtifactConfiguration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J%\u0010\t\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J*\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0016J'\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001cR\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/web/js/JsBackendPipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/web/WebBackendPipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/web/JsBackendPipelineArtifact;", "<init>", "()V", "configFiles", "Lorg/jetbrains/kotlin/cli/jvm/compiler/EnvironmentConfigFiles;", "getConfigFiles", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/EnvironmentConfigFiles;", "compileIncrementally", "icCaches", "Lorg/jetbrains/kotlin/cli/js/IcCachesArtifacts;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/CompilationOutputs;", "artifactConfiguration", "Lorg/jetbrains/kotlin/js/config/WebArtifactConfiguration;", "compileIncrementally$cli_js", "compileNonIncrementally", "module", "Lorg/jetbrains/kotlin/ir/backend/js/ModulesStructure;", "mainCallArguments", "", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "ir2JsTransformer", "Lorg/jetbrains/kotlin/cli/js/Ir2JsTransformer;", "compileNonIncrementally$cli_js", "cli-js"})
@SourceDebugExtension(value={"SMAP\nJsBackendPipelinePhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsBackendPipelinePhase.kt\norg/jetbrains/kotlin/cli/pipeline/web/js/JsBackendPipelinePhase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n812#2,12:124\n*S KotlinDebug\n*F\n+ 1 JsBackendPipelinePhase.kt\norg/jetbrains/kotlin/cli/pipeline/web/js/JsBackendPipelinePhase\n*L\n57#1:124,12\n*E\n"})
public final class JsBackendPipelinePhase
extends WebBackendPipelinePhase<JsBackendPipelineArtifact> {
    @NotNull
    public static final JsBackendPipelinePhase INSTANCE = new JsBackendPipelinePhase();

    private JsBackendPipelinePhase() {
        super("JsBackendPipelinePhase");
    }

    @Override
    @NotNull
    protected EnvironmentConfigFiles getConfigFiles() {
        return EnvironmentConfigFiles.JS_CONFIG_FILES;
    }

    @Override
    @NotNull
    public JsBackendPipelineArtifact compileIncrementally(@NotNull IcCachesArtifacts icCaches, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)icCaches, (String)"icCaches");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        WebArtifactConfiguration webArtifactConfiguration = JSConfigurationKeysKt.getArtifactConfiguration(configuration);
        Intrinsics.checkNotNull((Object)webArtifactConfiguration);
        CompilationOutputs outputs = this.compileIncrementally$cli_js(icCaches, configuration, webArtifactConfiguration);
        File file = JSConfigurationKeysKt.getOutputDir(configuration);
        Intrinsics.checkNotNull((Object)file);
        return new JsBackendPipelineArtifact(outputs, file, configuration);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilationOutputs compileIncrementally$cli_js(@NotNull IcCachesArtifacts icCaches, @NotNull CompilerConfiguration configuration, @NotNull WebArtifactConfiguration artifactConfiguration) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)icCaches, (String)"icCaches");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)artifactConfiguration, (String)"artifactConfiguration");
        MessageCollector messageCollector = CommonConfigurationKeysKt.getMessageCollector(configuration);
        long beforeIc2Js = System.currentTimeMillis();
        Iterable $this$filterIsInstance$iv = icCaches.getArtifacts();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JsModuleArtifact)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List jsArtifacts = (List)destination$iv$iv;
        JsExecutableProducer jsExecutableProducer = new JsExecutableProducer(artifactConfiguration.getModuleName(), artifactConfiguration.getModuleKind(), SourceMapsInfo.Companion.from(configuration), jsArtifacts, true);
        JsExecutableProducer.BuildResult buildResult = jsExecutableProducer.buildExecutable(artifactConfiguration.getGranularity(), false);
        CompilationOutputs outputs = buildResult.component1();
        List<String> rebuiltModules = buildResult.component2();
        outputs.writeAll(artifactConfiguration);
        MessageCollector.report$default(messageCollector, CompilerMessageSeverity.LOGGING, "Executable production duration (IC): " + (System.currentTimeMillis() - beforeIc2Js) + "ms", null, 4, null);
        for (Map.Entry<String, Long> entry : jsExecutableProducer.getStopwatchLaps().entrySet()) {
            String event = entry.getKey();
            long duration = ((Number)entry.getValue()).longValue();
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.LOGGING, "  " + event + ": " + (int)((double)duration / 1000000.0) + "ms", null, 4, null);
        }
        for (String string : rebuiltModules) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.LOGGING, "IC module builder rebuilt JS for module [" + new File(string).getName() + ']', null, 4, null);
        }
        return outputs;
    }

    @Override
    @Nullable
    public JsBackendPipelineArtifact compileNonIncrementally(@NotNull CompilerConfiguration configuration, @NotNull ModulesStructure module2, @Nullable List<String> mainCallArguments) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        MessageCollector messageCollector = CommonConfigurationKeysKt.getMessageCollector(configuration);
        Ir2JsTransformer ir2JsTransformer = new Ir2JsTransformer(configuration, module2, messageCollector, mainCallArguments);
        WebArtifactConfiguration webArtifactConfiguration = JSConfigurationKeysKt.getArtifactConfiguration(configuration);
        Intrinsics.checkNotNull((Object)webArtifactConfiguration);
        CompilationOutputs compilationOutputs = this.compileNonIncrementally$cli_js(messageCollector, ir2JsTransformer, webArtifactConfiguration);
        if (compilationOutputs == null) {
            return null;
        }
        CompilationOutputs outputs = compilationOutputs;
        File file = JSConfigurationKeysKt.getOutputDir(configuration);
        Intrinsics.checkNotNull((Object)file);
        return new JsBackendPipelineArtifact(outputs, file, configuration);
    }

    @Nullable
    public final CompilationOutputs compileNonIncrementally$cli_js(@NotNull MessageCollector messageCollector, @NotNull Ir2JsTransformer ir2JsTransformer, @NotNull WebArtifactConfiguration artifactConfiguration) {
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)ir2JsTransformer, (String)"ir2JsTransformer");
        Intrinsics.checkNotNullParameter((Object)artifactConfiguration, (String)"artifactConfiguration");
        long start = System.currentTimeMillis();
        try {
            CompilationOutputsBuilt outputs = ir2JsTransformer.compileAndTransformIrNew();
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.LOGGING, "Executable production duration: " + (System.currentTimeMillis() - start) + "ms", null, 4, null);
            outputs.writeAll(artifactConfiguration);
            return outputs;
        }
        catch (CompilationException e2) {
            messageCollector.report(CompilerMessageSeverity.ERROR, ExceptionsKt.stackTraceToString((Throwable)e2), CompilerMessageLocation.Companion.create(e2.getPath(), e2.getLine(), e2.getColumn(), e2.getContent()));
            return null;
        }
    }
}

