/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmIrAttributesKt;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsUsageLowering;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003*\u0002\r\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "declarationTransformer", "org/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering$declarationTransformer$1", "Lorg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering$declarationTransformer$1;", "usagesTransformer", "org/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering$usagesTransformer$1", "Lorg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering$usagesTransformer$1;", "backend.wasm"})
public final class ComplexExternalDeclarationsUsageLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final declarationTransformer.1 declarationTransformer;
    @NotNull
    private final usagesTransformer.1 usagesTransformer;

    public ComplexExternalDeclarationsUsageLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.declarationTransformer = new IrVisitorVoid(this){
            final /* synthetic */ ComplexExternalDeclarationsUsageLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            public void visitFile(IrFile declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                this.process(declaration);
            }

            public void visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (!declaration.isExternal()) {
                    this.process(declaration);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void process(IrDeclarationContainer container) {
                List<IrDeclaration> $this$transformFlat$iv = container.getDeclarations();
                boolean $i$f$transformFlat = false;
                int i$iv = 0;
                while (i$iv < $this$transformFlat$iv.size()) {
                    List list;
                    void member;
                    IrDeclaration item$iv;
                    IrDeclaration irDeclaration = item$iv = $this$transformFlat$iv.get(i$iv);
                    List<IrDeclaration> list2 = $this$transformFlat$iv;
                    boolean bl = false;
                    if (member instanceof IrFunction && WasmIrAttributesKt.getTopLevelFunctionForNestedExternal((IrFunction)member) != null) {
                        list = CollectionsKt.emptyList();
                    } else {
                        IrVisitorsKt.acceptVoid((IrElement)member, this);
                        list = null;
                    }
                    i$iv = TransformKt.replaceInPlace(list2, list, i$iv);
                }
            }

            public void visitBody(IrBody body) {
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                IrElementTransformerVoidKt.transformChildrenVoid(body, ComplexExternalDeclarationsUsageLowering.access$getUsagesTransformer$p(this.this$0));
            }
        };
        this.usagesTransformer = new IrElementTransformerVoid(this){
            final /* synthetic */ ComplexExternalDeclarationsUsageLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrExpression visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                return this.transformCall(expression2);
            }

            public IrExpression visitConstructorCall(IrConstructorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                return this.transformCall(expression2);
            }

            public IrExpression visitGetObjectValue(IrGetObjectValue expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrSimpleFunction irSimpleFunction = WasmIrAttributesKt.getGetInstanceFunctionForExternalObject((IrClass)expression2.getSymbol().getOwner());
                if (irSimpleFunction == null) {
                    return expression2;
                }
                IrSimpleFunction externalGetInstance = irSimpleFunction;
                return BuildersKt.IrCallImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), externalGetInstance.getSymbol(), 0, null, null, 96, null);
            }

            public final IrExpression transformCall(IrFunctionAccessExpression call2) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                IrFunction oldFun = IrResolveUtilsKt.getRealOverrideTarget(((IrFunctionSymbol)call2.getSymbol()).getOwner());
                IrSimpleFunction irSimpleFunction = WasmIrAttributesKt.getTopLevelFunctionForNestedExternal(oldFun);
                if (irSimpleFunction == null) {
                    return call2;
                }
                IrSimpleFunction newFun2 = irSimpleFunction;
                IrCallImpl newCall = BuildersKt.IrCallImpl$default(call2.getStartOffset(), call2.getEndOffset(), newFun2.getReturnType(), newFun2.getSymbol(), 0, null, null, 112, null);
                for (IrValueParameter parameter : oldFun.getParameters()) {
                    IrExpression arg = (IrExpression)call2.getArguments().get(parameter.getIndexInParameters());
                    newCall.getArguments().set(parameter.getIndexInParameters(), arg == null && !AdditionalIrUtilsKt.isVararg(parameter) ? (IrExpression)IrUtilsKt.defaultValueForType(IrConstImpl.Companion, -1, -1, parameter.getType()) : arg);
                }
                int numDefaultParameters = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.access$numDefaultParametersForExternalFunction(oldFun);
                int firstOldDefaultArgumentIdx = oldFun.getParameters().size() - numDefaultParameters;
                int firstDefaultFlagArgumentIdx = newFun2.getParameters().size() - numDefaultParameters;
                for (int i2 = 0; i2 < numDefaultParameters; ++i2) {
                    int value2 = call2.getArguments().get(i2 + firstOldDefaultArgumentIdx) == null ? 1 : 0;
                    newCall.getArguments().set(firstDefaultFlagArgumentIdx + i2, IrConstImpl.Companion.int(-1, -1, this.this$0.getContext().getIrBuiltIns().getIntType(), value2));
                }
                return newCall;
            }
        };
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrVisitorsKt.acceptVoid((IrElement)irFile, this.declarationTransformer);
    }

    public static final /* synthetic */ usagesTransformer.1 access$getUsagesTransformer$p(ComplexExternalDeclarationsUsageLowering $this) {
        return $this.usagesTransformer;
    }
}

