/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmCachedDeclarations;
import org.jetbrains.kotlin.backend.jvm.ir.JvmDefaultUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceSuperCallsLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@PhaseDescription(name="InterfaceSuperCalls")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceSuperCallsLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "postprocessMovedThis", "irCall", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nInterfaceSuperCallsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterfaceSuperCallsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InterfaceSuperCallsLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class InterfaceSuperCallsLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public InterfaceSuperCallsLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrClass superQualifierClass;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClassSymbol irClassSymbol = expression2.getSuperQualifierSymbol();
        IrClass irClass = superQualifierClass = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
        if (superQualifierClass == null || !IrUtilsKt.isInterface(superQualifierClass) || IrUtilsKt.isSuperToAny(expression2)) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction superCallee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (JvmDefaultUtilsKt.isDefinitelyNotDefaultImplsMethod(superCallee, this.context.getConfig().getJvmDefaultMode(), (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(superCallee, null, 1, null))) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction redirectTarget = JvmCachedDeclarations.getDefaultImplsFunction$default(this.context.getCachedDeclarations(), superCallee, false, 2, null);
        IrCall newCall = JvmIrUtilsKt.createDelegatingCallWithPlaceholderTypeArguments(expression2, redirectTarget, this.context.getIrBuiltIns());
        this.postprocessMovedThis(newCall);
        return super.visitCall(newCall);
    }

    private final void postprocessMovedThis(IrCall irCall) {
        Object v0;
        block2: {
            Iterable iterable = ((IrSimpleFunction)irCall.getSymbol().getOwner()).getParameters();
            for (Object t2 : iterable) {
                IrValueParameter it = (IrValueParameter)t2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.Companion.getMOVED_DISPATCH_RECEIVER())) continue;
                v0 = t2;
                break block2;
            }
            v0 = null;
        }
        IrValueParameter irValueParameter = v0;
        if (irValueParameter == null) {
            return;
        }
        IrValueParameter movedThisParameter = irValueParameter;
        IrExpression irExpression = irCall.getArguments().get(movedThisParameter);
        irCall.getArguments().set(movedThisParameter, irExpression != null ? InterfaceSuperCallsLoweringKt.reinterpretAsDispatchReceiverOfType(irExpression, movedThisParameter.getType()) : null);
    }
}

