/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.ir.declarations.persistent.carriers

import org.jetbrains.kotlin.descriptors.DescriptorVisibility
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation
import org.jetbrains.kotlin.descriptors.Modality
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter
import org.jetbrains.kotlin.ir.declarations.IrValueParameter
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol
import org.jetbrains.kotlin.ir.symbols.IrSymbol
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol
import org.jetbrains.kotlin.ir.types.IrSimpleType
import org.jetbrains.kotlin.ir.types.IrType

// Auto-generated by compiler/ir/ir.tree.persistent/generator/src/org/jetbrains/kotlin/ir/persistentIrGenerator/Main.kt. DO NOT EDIT!

internal interface ClassCarrier : DeclarationCarrier{
    val thisReceiverField: IrValueParameter?
    val thisReceiverSymbolField: IrValueParameterSymbol?
    val visibilityField: DescriptorVisibility
    val modalityField: Modality
    val typeParametersField: List<IrTypeParameter>
    val typeParametersSymbolField: List<IrTypeParameterSymbol>
    val superTypesField: List<IrType>
    val inlineClassRepresentationField: InlineClassRepresentation<IrSimpleType>?
    val sealedSubclassesField: List<IrClassSymbol>

    override fun clone(): ClassCarrier {
        return ClassCarrierImpl(
            lastModified,
            parentSymbolField,
            originField,
            annotationsField,
            thisReceiverSymbolField,
            visibilityField,
            modalityField,
            typeParametersSymbolField,
            superTypesField,
            inlineClassRepresentationField,
            sealedSubclassesField
        )
    }
}

internal class ClassCarrierImpl(
    override val lastModified: Int,
    override val parentSymbolField: IrSymbol?,
    override val originField: IrDeclarationOrigin,
    override val annotationsField: List<IrConstructorCall>,
    override val thisReceiverSymbolField: IrValueParameterSymbol?,
    override val visibilityField: DescriptorVisibility,
    override val modalityField: Modality,
    override val typeParametersSymbolField: List<IrTypeParameterSymbol>,
    override val superTypesField: List<IrType>,
    override val inlineClassRepresentationField: InlineClassRepresentation<IrSimpleType>?,
    override val sealedSubclassesField: List<IrClassSymbol>
) : ClassCarrier {

    override val thisReceiverField: IrValueParameter?
        get() = thisReceiverSymbolField?.owner

    override val typeParametersField: List<IrTypeParameter> by lazy { typeParametersSymbolField.map { it.owner } }
}
