/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.atteo.evo.inflector.English;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\tH\u0002\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u000b\u001a#\u0010\f\u001a\u00020\u0007*\u00020\u00072\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010\u001a&\u0010\u0011\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u00132\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u0012\u0010\u0016\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0001\u001a\u0012\u0010\u0016\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\t\u001a\u0012\u0010\u0018\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0001\u001a\u0012\u0010\u0018\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"IN_DAY", "", "IN_HOUR", "IN_MINUTE", "IN_SECOND", "knownPluralForms", "", "", "coerceToIntegerMax", "", "formatDuration", "Ljava/time/Duration;", "formatMessage", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "listPresentationInColumns", "T", "", "columns", "minColumnWidth", "pluralize", "times", "pluralizeWithNumber", "structure-base"})
@SourceDebugExtension(value={"SMAP\nFormatUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatUtils.kt\ncom/jetbrains/plugin/structure/base/utils/FormatUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1549#2:83\n1620#2,3:84\n*E\n*S KotlinDebug\n*F\n+ 1 FormatUtils.kt\ncom/jetbrains/plugin/structure/base/utils/FormatUtilsKt\n*L\n53#1:83\n53#1,3:84\n*E\n"})
public final class FormatUtilsKt {
    private static final int IN_SECOND = 1000;
    private static final int IN_MINUTE = 60000;
    private static final int IN_HOUR = 3600000;
    private static final int IN_DAY = 86400000;
    private static final Map<String, String> knownPluralForms = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"this", (Object)"these"), TuplesKt.to((Object)"that", (Object)"those"), TuplesKt.to((Object)"is", (Object)"are"), TuplesKt.to((Object)"was", (Object)"were")});

    @NotNull
    public static final String formatDuration(@NotNull Duration $this$formatDuration) {
        Intrinsics.checkNotNullParameter((Object)$this$formatDuration, (String)"$this$formatDuration");
        long millis = $this$formatDuration.toMillis();
        long days = millis / (long)86400000;
        long hours = (millis %= (long)86400000) / (long)3600000;
        long minutes = (millis %= (long)3600000) / (long)60000;
        long seconds = (millis %= (long)60000) / (long)1000;
        millis %= (long)1000;
        if (days > 0L) {
            return days + " d " + hours + " h " + minutes + " m";
        }
        if (hours > 0L) {
            return hours + " h " + minutes + " m " + seconds + " s";
        }
        if (minutes > 0L) {
            return minutes + " m " + seconds + " s " + millis + " ms";
        }
        if (seconds > 0L) {
            return seconds + " s " + millis + " ms";
        }
        return millis + " ms";
    }

    @NotNull
    public static final String formatMessage(@NotNull String $this$formatMessage, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)$this$formatMessage, (String)"$this$formatMessage");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = new MessageFormat($this$formatMessage).format(args);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MessageFormat(this).format(args)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> String listPresentationInColumns(@NotNull List<? extends T> $this$listPresentationInColumns, int columns, int minColumnWidth) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$listPresentationInColumns, (String)"$this$listPresentationInColumns");
        List<T> list = $this$listPresentationInColumns;
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int pos = 0; pos < list.size(); pos += columns) {
            void $this$mapTo$iv$iv;
            int n = pos + columns;
            int n2 = list.size();
            List<? extends T> subList = list.subList(pos, Math.min(n, n2));
            Iterable $this$map$iv = subList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = String.valueOf(it);
                collection.add(string);
            }
            String row = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(list, columns, minColumnWidth){
                final /* synthetic */ List $list$inlined;
                final /* synthetic */ int $columns$inlined;
                final /* synthetic */ int $minColumnWidth$inlined;
                {
                    this.$list$inlined = list;
                    this.$columns$inlined = n;
                    this.$minColumnWidth$inlined = n2;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return StringsKt.padEnd$default((String)it, (int)this.$minColumnWidth$inlined, (char)'\u0000', (int)2, null);
                }
            }), (int)30, null);
            StringBuilder stringBuilder2 = $this$buildString;
            StringBuilder stringBuilder3 = stringBuilder2.append(row);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String pluralizeWithNumber(@NotNull String $this$pluralizeWithNumber, int times) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralizeWithNumber, (String)"$this$pluralizeWithNumber");
        return times + " " + FormatUtilsKt.pluralize($this$pluralizeWithNumber, times);
    }

    @NotNull
    public static final String pluralizeWithNumber(@NotNull String $this$pluralizeWithNumber, long times) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralizeWithNumber, (String)"$this$pluralizeWithNumber");
        return FormatUtilsKt.pluralizeWithNumber($this$pluralizeWithNumber, FormatUtilsKt.coerceToIntegerMax(times));
    }

    private static final int coerceToIntegerMax(long $this$coerceToIntegerMax) {
        return (int)RangesKt.coerceAtMost((long)$this$coerceToIntegerMax, (long)Integer.MAX_VALUE);
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize, long times) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"$this$pluralize");
        return FormatUtilsKt.pluralize($this$pluralize, FormatUtilsKt.coerceToIntegerMax(times));
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize, int times) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"$this$pluralize");
        if (times < 0) {
            throw (Throwable)new IllegalArgumentException("Negative value");
        }
        if (times == 1) {
            return $this$pluralize;
        }
        String string = knownPluralForms.get($this$pluralize);
        if (string == null) {
            String string2 = English.plural((String)$this$pluralize, (int)times);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"English.plural(this, times)");
        }
        return string;
    }
}

