/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.jodatime;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.jodatime.DateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/exposed/sql/jodatime/DateColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "time", "", "(Z)V", "hasTimePart", "getHasTimePart", "()Z", "getTime", "equals", "other", "", "hashCode", "", "nonNullValueToString", "", "value", "notNullValueToDB", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "sqlType", "valueFromDB", "Companion", "exposed-jodatime"})
public final class DateColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    public static final Companion Companion;
    private final boolean time;
    private final boolean hasTimePart;
    @Nullable
    private static final Class<?> localDateTimeClass;

    public DateColumnType(boolean time) {
        super(false, 1, null);
        this.hasTimePart = this.time = time;
    }

    public final boolean getTime() {
        return this.time;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return this.time ? DefaultKt.getCurrentDialect().getDataTypeProvider().dateTimeType() : "DATE";
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        DateTime dateTime;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof String) {
            return (String)value;
        }
        Object object = value;
        if (object instanceof DateTime) {
            dateTime = (DateTime)value;
        } else if (object instanceof Date) {
            dateTime = new DateTime(((Date)value).getTime());
        } else if (object instanceof Timestamp) {
            dateTime = new DateTime(((Timestamp)value).getTime());
        } else {
            String string = "Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        DateTime dateTime2 = dateTime;
        return this.time ? '\'' + DateColumnTypeKt.access$getDEFAULT_DATE_TIME_STRING_FORMATTER$p().print((ReadableInstant)dateTime2.toDateTime(DateTimeZone.getDefault())) + '\'' : '\'' + DateColumnTypeKt.access$getDEFAULT_DATE_STRING_FORMATTER$p().print((ReadableInstant)dateTime2) + '\'';
    }

    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        Object object2 = object instanceof DateTime ? value : (object instanceof Date ? new DateTime(((Date)value).getTime()) : (object instanceof Timestamp ? new DateTime(((Timestamp)value).getTime()) : (object instanceof Integer ? new DateTime((long)((Number)value).intValue()) : (object instanceof Long ? new DateTime(((Number)value).longValue()) : (object instanceof String ? (this.time ? DateTime.parse((String)((String)value), (DateTimeFormatter)DateColumnTypeKt.access$formatterForDateTimeString((String)value)) : (DefaultKt.getCurrentDialect() instanceof SQLiteDialect ? DateColumnTypeKt.access$getSQLITE_DATE_STRING_FORMATTER$p().parseDateTime((String)value) : DateColumnTypeKt.access$getDEFAULT_DATE_STRING_FORMATTER$p().parseDateTime((String)value))) : (Intrinsics.areEqual(localDateTimeClass, value.getClass()) ? DateTime.parse((String)value.toString()) : this.valueFromDB(value.toString())))))));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"when (value) {\n        is DateTime -> value\n        is java.sql.Date -> DateTime(value.time)\n        is java.sql.Timestamp -> DateTime(value.time)\n        is Int -> DateTime(value.toLong())\n        is Long -> DateTime(value)\n        is String -> when {\n            time -> DateTime.parse(value, formatterForDateTimeString(value))\n            currentDialect is SQLiteDialect -> SQLITE_DATE_STRING_FORMATTER.parseDateTime(value)\n            else -> DEFAULT_DATE_STRING_FORMATTER.parseDateTime(value)\n        }\n        else -> {\n            if (localDateTimeClass == value.javaClass)\n                DateTime.parse(value.toString())\n            else\n                valueFromDB(value.toString())\n        }\n    }");
        return object2;
    }

    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return this.time && localDateTimeClass != null && DefaultKt.getCurrentDialect() instanceof MysqlDialect ? rs.getObject(index, localDateTimeClass) : (this.time && DefaultKt.getCurrentDialect() instanceof MysqlDialect && !(DefaultKt.getCurrentDialect() instanceof MariaDBDialect) ? rs.getObject(index, String.class) : super.readObject(rs, index));
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof DateTime && this.time && DefaultKt.getCurrentDialect() instanceof SQLiteDialect) {
            String string = DateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$p().print((ReadableInstant)value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER.print(value)");
            object = string;
        } else {
            object = value instanceof DateTime && this.time ? new Timestamp(((DateTime)value).getMillis()) : (value instanceof DateTime ? new Date(((DateTime)value).getMillis()) : value);
        }
        return object;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DateColumnType)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return this.time == ((DateColumnType)((Object)other)).time;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Boolean.hashCode(this.time);
        return result;
    }

    static {
        Class<?> clazz;
        Companion = new Companion(null);
        try {
            clazz = Class.forName("java.time.LocalDateTime", false, Companion.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        localDateTimeClass = clazz;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/jodatime/DateColumnType$Companion;", "", "()V", "localDateTimeClass", "Ljava/lang/Class;", "exposed-jodatime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

