/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.pagehelper.parser;

import java.util.List;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.minidao.pagehelper.PageException;

public class OrderByParser {
    private static final Log log = LogFactory.getLog(OrderByParser.class);

    public static String converToOrderBySql(String sql, String orderBy) {
        Statement stmt = null;
        try {
            stmt = CCJSqlParserUtil.parse((String)sql);
            Select select = (Select)stmt;
            SelectBody selectBody = select.getSelectBody();
            List<OrderByElement> orderByElements = OrderByParser.extraOrderBy(selectBody);
            String defaultOrderBy = PlainSelect.orderByToString(orderByElements);
            if (defaultOrderBy.indexOf(63) != -1) {
                throw new PageException("\u539fSQL[" + sql + "]\u4e2d\u7684order by\u5305\u542b\u53c2\u6570\uff0c\u56e0\u6b64\u4e0d\u80fd\u4f7f\u7528OrderBy\u63d2\u4ef6\u8fdb\u884c\u4fee\u6539!");
            }
            sql = select.toString();
        }
        catch (Throwable e) {
            log.warn((Object)("\u5904\u7406\u6392\u5e8f\u5931\u8d25: " + e + "\uff0c\u964d\u7ea7\u4e3a\u76f4\u63a5\u62fc\u63a5 order by \u53c2\u6570"));
        }
        return sql + " order by " + orderBy;
    }

    public static List<OrderByElement> extraOrderBy(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            List orderByElements = ((PlainSelect)selectBody).getOrderByElements();
            ((PlainSelect)selectBody).setOrderByElements(null);
            return orderByElements;
        }
        if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSelectBody() != null) {
                return OrderByParser.extraOrderBy(withItem.getSelectBody());
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                List plainSelects = operationList.getSelects();
                return OrderByParser.extraOrderBy((SelectBody)plainSelects.get(plainSelects.size() - 1));
            }
        }
        return null;
    }
}

