/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.report.datastatistics.graphicanalysis;

import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.core.req.WeiXinReqService;
import org.jeewx.api.core.req.model.dataCube.WxDataCubeStreamArticleSummaryParam;
import org.jeewx.api.core.req.model.dataCube.WxDataCubeStreamArticleTotalParam;
import org.jeewx.api.core.req.model.dataCube.WxDataCubeStreamUserReadHourParam;
import org.jeewx.api.core.req.model.dataCube.WxDataCubeStreamUserReadParam;
import org.jeewx.api.core.req.model.dataCube.WxDataCubeStreamUserShareHourParam;
import org.jeewx.api.core.req.model.dataCube.WxDataCubeStreamUserShareParam;
import org.jeewx.api.report.datastatistics.graphicanalysis.model.GraphicAnalysisRtnInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwGraphicAnalysisAPI {
    private static Logger logger = LoggerFactory.getLogger(JwGraphicAnalysisAPI.class);

    private static Long getDays(String Date1, String Date2) {
        return Date.valueOf(Date1).getTime() / 86400000L - Date.valueOf(Date2).getTime() / 86400000L;
    }

    public static List<GraphicAnalysisRtnInfo> getArticleSummary(String accesstoken, String begin_date, String end_date) throws WexinReqException, UnsupportedEncodingException {
        if (accesstoken != null) {
            if (JwGraphicAnalysisAPI.getDays(end_date, begin_date) >= 1L) {
                logger.error("\u4f20\u5165\u7684\u65e5\u671f\u95f4\u9694\u5927\u4e8e1\u5929");
                return null;
            }
            WxDataCubeStreamArticleSummaryParam articleSummary = new WxDataCubeStreamArticleSummaryParam();
            articleSummary.setAccess_token(accesstoken);
            articleSummary.setBegin_date(begin_date);
            articleSummary.setEnd_date(end_date);
            JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(articleSummary);
            ArrayList<GraphicAnalysisRtnInfo> graphicAnalysisRtnInfoList = new ArrayList<GraphicAnalysisRtnInfo>();
            Object error = result.get("errcode");
            JSONArray array = null;
            GraphicAnalysisRtnInfo graphicAnalysisRtnInfo = null;
            array = (JSONArray)result.get("list");
            for (Object object : array) {
                graphicAnalysisRtnInfo = (GraphicAnalysisRtnInfo)JSONObject.toBean((JSONObject)((JSONObject)object), GraphicAnalysisRtnInfo.class);
                graphicAnalysisRtnInfoList.add(graphicAnalysisRtnInfo);
            }
            return graphicAnalysisRtnInfoList;
        }
        return null;
    }

    public static List<GraphicAnalysisRtnInfo> getArticleTotal(String accesstoken, String begin_date, String end_date) throws WexinReqException, UnsupportedEncodingException {
        if (accesstoken != null) {
            if (JwGraphicAnalysisAPI.getDays(end_date, begin_date) >= 1L) {
                logger.error("\u4f20\u5165\u7684\u65e5\u671f\u95f4\u9694\u5927\u4e8e1\u5929");
                return null;
            }
            WxDataCubeStreamArticleTotalParam articleTotal = new WxDataCubeStreamArticleTotalParam();
            articleTotal.setAccess_token(accesstoken);
            articleTotal.setBegin_date(begin_date);
            articleTotal.setEnd_date(end_date);
            JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(articleTotal);
            ArrayList<GraphicAnalysisRtnInfo> graphicAnalysisRtnInfoList = new ArrayList<GraphicAnalysisRtnInfo>();
            Object error = result.get("errcode");
            JSONArray array = null;
            GraphicAnalysisRtnInfo graphicAnalysisRtnInfo = null;
            array = (JSONArray)result.get("list");
            Gson gson = new Gson();
            for (Object object : array) {
                graphicAnalysisRtnInfo = (GraphicAnalysisRtnInfo)gson.fromJson(object.toString(), GraphicAnalysisRtnInfo.class);
                graphicAnalysisRtnInfoList.add(graphicAnalysisRtnInfo);
            }
            return graphicAnalysisRtnInfoList;
        }
        return null;
    }

    public static List<GraphicAnalysisRtnInfo> getUserRead(String accesstoken, String begin_date, String end_date) throws WexinReqException {
        if (accesstoken != null) {
            if (JwGraphicAnalysisAPI.getDays(end_date, begin_date) >= 3L) {
                logger.error("\u4f20\u5165\u7684\u65e5\u671f\u95f4\u9694\u5927\u4e8e3\u5929");
                return null;
            }
            WxDataCubeStreamUserReadParam userRead = new WxDataCubeStreamUserReadParam();
            userRead.setAccess_token(accesstoken);
            userRead.setBegin_date(begin_date);
            userRead.setEnd_date(end_date);
            JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(userRead);
            ArrayList<GraphicAnalysisRtnInfo> graphicAnalysisRtnInfoList = new ArrayList<GraphicAnalysisRtnInfo>();
            Object error = result.get("errcode");
            JSONArray array = null;
            GraphicAnalysisRtnInfo graphicAnalysisRtnInfo = null;
            array = (JSONArray)result.get("list");
            for (Object object : array) {
                graphicAnalysisRtnInfo = (GraphicAnalysisRtnInfo)JSONObject.toBean((JSONObject)((JSONObject)object), GraphicAnalysisRtnInfo.class);
                graphicAnalysisRtnInfoList.add(graphicAnalysisRtnInfo);
            }
            return graphicAnalysisRtnInfoList;
        }
        return null;
    }

    public static List<GraphicAnalysisRtnInfo> getUserReadHour(String accesstoken, String begin_date, String end_date) throws WexinReqException {
        if (accesstoken != null) {
            if (JwGraphicAnalysisAPI.getDays(end_date, begin_date) >= 1L) {
                logger.error("\u4f20\u5165\u7684\u65e5\u671f\u95f4\u9694\u5927\u4e8e1\u5929");
                return null;
            }
            WxDataCubeStreamUserReadHourParam userReadHour = new WxDataCubeStreamUserReadHourParam();
            userReadHour.setAccess_token(accesstoken);
            userReadHour.setBegin_date(begin_date);
            userReadHour.setEnd_date(end_date);
            JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(userReadHour);
            ArrayList<GraphicAnalysisRtnInfo> graphicAnalysisRtnInfoList = new ArrayList<GraphicAnalysisRtnInfo>();
            Object error = result.get("errcode");
            JSONArray array = null;
            GraphicAnalysisRtnInfo graphicAnalysisRtnInfo = null;
            array = (JSONArray)result.get("list");
            for (Object object : array) {
                graphicAnalysisRtnInfo = (GraphicAnalysisRtnInfo)JSONObject.toBean((JSONObject)((JSONObject)object), GraphicAnalysisRtnInfo.class);
                graphicAnalysisRtnInfoList.add(graphicAnalysisRtnInfo);
            }
            return graphicAnalysisRtnInfoList;
        }
        return null;
    }

    public static List<GraphicAnalysisRtnInfo> getUserShare(String accesstoken, String begin_date, String end_date) throws WexinReqException {
        if (accesstoken != null) {
            if (JwGraphicAnalysisAPI.getDays(end_date, begin_date) >= 7L) {
                logger.error("\u4f20\u5165\u7684\u65e5\u671f\u95f4\u9694\u5927\u4e8e7\u5929");
                return null;
            }
            WxDataCubeStreamUserShareParam userShare = new WxDataCubeStreamUserShareParam();
            userShare.setAccess_token(accesstoken);
            userShare.setBegin_date(begin_date);
            userShare.setEnd_date(end_date);
            JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(userShare);
            ArrayList<GraphicAnalysisRtnInfo> graphicAnalysisRtnInfoList = new ArrayList<GraphicAnalysisRtnInfo>();
            Object error = result.get("errcode");
            JSONArray array = null;
            GraphicAnalysisRtnInfo graphicAnalysisRtnInfo = null;
            array = (JSONArray)result.get("list");
            for (Object object : array) {
                graphicAnalysisRtnInfo = (GraphicAnalysisRtnInfo)JSONObject.toBean((JSONObject)((JSONObject)object), GraphicAnalysisRtnInfo.class);
                graphicAnalysisRtnInfoList.add(graphicAnalysisRtnInfo);
            }
            return graphicAnalysisRtnInfoList;
        }
        return null;
    }

    public static List<GraphicAnalysisRtnInfo> getUserShareHour(String accesstoken, String begin_date, String end_date) throws WexinReqException {
        if (accesstoken != null) {
            if (JwGraphicAnalysisAPI.getDays(end_date, begin_date) >= 1L) {
                logger.error("\u4f20\u5165\u7684\u65e5\u671f\u95f4\u9694\u5927\u4e8e1\u5929");
                return null;
            }
            WxDataCubeStreamUserShareHourParam userShareHour = new WxDataCubeStreamUserShareHourParam();
            userShareHour.setAccess_token(accesstoken);
            userShareHour.setBegin_date(begin_date);
            userShareHour.setEnd_date(end_date);
            JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(userShareHour);
            ArrayList<GraphicAnalysisRtnInfo> graphicAnalysisRtnInfoList = new ArrayList<GraphicAnalysisRtnInfo>();
            Object error = result.get("errcode");
            JSONArray array = null;
            GraphicAnalysisRtnInfo graphicAnalysisRtnInfo = null;
            array = (JSONArray)result.get("list");
            for (Object object : array) {
                graphicAnalysisRtnInfo = (GraphicAnalysisRtnInfo)JSONObject.toBean((JSONObject)((JSONObject)object), GraphicAnalysisRtnInfo.class);
                graphicAnalysisRtnInfoList.add(graphicAnalysisRtnInfo);
            }
            return graphicAnalysisRtnInfoList;
        }
        return null;
    }
}

