/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.util;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class PoiCellUtil {
    public static String getCellValue(Sheet sheet, int row, int column) {
        String value = null;
        if (PoiCellUtil.isMergedRegion(sheet, row, column)) {
            value = PoiCellUtil.getMergedRegionValue(sheet, row, column);
        } else {
            Row rowData = sheet.getRow(row);
            Cell cell = rowData.getCell(column);
            value = PoiCellUtil.getCellValue(cell);
        }
        return value;
    }

    public static String getMergedRegionValue(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            Cell fCell = fRow.getCell(firstColumn);
            return PoiCellUtil.getCellValue(fCell);
        }
        return null;
    }

    public static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            return true;
        }
        return false;
    }

    public static String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == 1) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == 4) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == 2) {
            return cell.getCellFormula();
        }
        if (cell.getCellType() == 0) {
            return String.valueOf(cell.getNumericCellValue());
        }
        cell.setCellType(1);
        return cell.getStringCellValue();
    }
}

