/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.html.css.impl;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.jeecgframework.poi.excel.html.css.ICssConvertToExcel;
import org.jeecgframework.poi.excel.html.css.ICssConvertToHtml;
import org.jeecgframework.poi.excel.html.entity.style.CellStyleBorderEntity;
import org.jeecgframework.poi.excel.html.entity.style.CellStyleEntity;
import org.jeecgframework.poi.util.PoiCssUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BorderCssConverImpl
implements ICssConvertToExcel,
ICssConvertToHtml {
    private static Logger log = LoggerFactory.getLogger(BorderCssConverImpl.class);

    @Override
    public String convertToHtml(Cell cell, CellStyle cellStyle, CellStyleEntity style) {
        return null;
    }

    @Override
    public void convertToExcel(Cell cell, CellStyle cellStyle, CellStyleEntity style) {
        if (style == null || style.getBorder() == null) {
            return;
        }
        CellStyleBorderEntity border = style.getBorder();
        for (String pos : new String[]{"top", "right", "bottom", "left"}) {
            String posName = StringUtils.capitalize((String)pos.toLowerCase());
            String colorAttr = null;
            try {
                colorAttr = (String)MethodUtils.invokeMethod((Object)border, (String)("getBorder" + posName + "Color"), (Object[])new Object[0]);
            }
            catch (Exception e) {
                log.error("Set Border Style Error Caused.", (Throwable)e);
            }
            if (StringUtils.isNotEmpty(colorAttr)) {
                XSSFColor poiColor;
                if (cell instanceof HSSFCell && (poiColor = PoiCssUtils.parseColor((HSSFWorkbook)cell.getSheet().getWorkbook(), colorAttr)) != null) {
                    try {
                        MethodUtils.invokeMethod((Object)cellStyle, (String)("set" + posName + "BorderColor"), (Object[])new Object[]{poiColor.getIndex()});
                    }
                    catch (Exception e) {
                        log.error("Set Border Color Error Caused.", (Throwable)e);
                    }
                }
                if (cell instanceof XSSFCell && (poiColor = PoiCssUtils.parseColor(colorAttr)) != null) {
                    try {
                        MethodUtils.invokeMethod((Object)cellStyle, (String)("set" + posName + "BorderColor"), (Object[])new Object[]{poiColor});
                    }
                    catch (Exception e) {
                        log.error("Set Border Color Error Caused.", (Throwable)e);
                    }
                }
            }
            int width = 0;
            try {
                String widthStr = (String)MethodUtils.invokeMethod((Object)border, (String)("getBorder" + posName + "Width"), (Object[])new Object[0]);
                if (PoiCssUtils.isNum(widthStr)) {
                    width = Integer.parseInt(widthStr);
                }
            }
            catch (Exception e) {
                log.error("Set Border Style Error Caused.", (Throwable)e);
            }
            String styleValue = null;
            try {
                styleValue = (String)MethodUtils.invokeMethod((Object)border, (String)("getBorder" + posName + "Style"), (Object[])new Object[0]);
            }
            catch (Exception e) {
                log.error("Set Border Style Error Caused.", (Throwable)e);
            }
            int shortValue = -1;
            if (StringUtils.isBlank(styleValue) || "solid".equals(styleValue)) {
                shortValue = width > 2 ? 5 : (width > 1 ? 2 : 1);
            } else if (ArrayUtils.contains((Object[])new String[]{"none", "hidden"}, (Object)styleValue)) {
                shortValue = 0;
            } else if ("double".equals(styleValue)) {
                shortValue = 6;
            } else if ("dotted".equals(styleValue)) {
                shortValue = 4;
            } else if ("dashed".equals(styleValue)) {
                shortValue = width > 1 ? 8 : 3;
            }
            if (shortValue == -1) continue;
            try {
                MethodUtils.invokeMethod((Object)cellStyle, (String)("setBorder" + posName), (Object[])new Object[]{(short)shortValue});
            }
            catch (Exception e) {
                log.error("Set Border Style Error Caused.", (Throwable)e);
            }
        }
    }
}

