/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.input.sax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jdom2.JDOMException;
import org.jdom2.input.sax.XMLReaderSchemaFactory;
import org.xml.sax.SAXException;

public class XMLReaderXSDFactory
extends XMLReaderSchemaFactory {
    private static final ThreadLocal<SchemaFactory> schemafactl = new ThreadLocal<SchemaFactory>(){

        @Override
        protected SchemaFactory initialValue() {
            return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        }
    };

    private static final Schema getSchemaFromString(String ... systemID) throws JDOMException {
        if (systemID == null) {
            throw new NullPointerException("Cannot specify a null input array");
        }
        if (systemID.length == 0) {
            throw new IllegalArgumentException("You need at least one XSD source for an XML Schema validator");
        }
        Source[] urls = new Source[systemID.length];
        for (int i = 0; i < systemID.length; ++i) {
            if (systemID[i] == null) {
                throw new NullPointerException("Cannot specify a null SystemID");
            }
            urls[i] = new StreamSource(systemID[i]);
        }
        return XMLReaderXSDFactory.getSchemaFromSource(urls);
    }

    private static final Schema getSchemaFromFile(File ... systemID) throws JDOMException {
        if (systemID == null) {
            throw new NullPointerException("Cannot specify a null input array");
        }
        if (systemID.length == 0) {
            throw new IllegalArgumentException("You need at least one XSD source for an XML Schema validator");
        }
        Source[] sources = new Source[systemID.length];
        for (int i = 0; i < systemID.length; ++i) {
            if (systemID[i] == null) {
                throw new NullPointerException("Cannot specify a null SystemID");
            }
            sources[i] = new StreamSource(systemID[i]);
        }
        return XMLReaderXSDFactory.getSchemaFromSource(sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Schema getSchemaFromURL(URL ... systemID) throws JDOMException {
        if (systemID == null) {
            throw new NullPointerException("Cannot specify a null input array");
        }
        if (systemID.length == 0) {
            throw new IllegalArgumentException("You need at least one XSD source for an XML Schema validator");
        }
        InputStream[] streams = new InputStream[systemID.length];
        try {
            Source[] sources = new Source[systemID.length];
            for (int i = 0; i < systemID.length; ++i) {
                if (systemID[i] == null) {
                    throw new NullPointerException("Cannot specify a null SystemID");
                }
                InputStream is = null;
                try {
                    is = systemID[i].openStream();
                }
                catch (IOException e) {
                    throw new JDOMException("Unable to read Schema URL " + systemID[i].toString(), e);
                }
                streams[i] = is;
                sources[i] = new StreamSource(is, systemID[i].toString());
            }
            Schema schema = XMLReaderXSDFactory.getSchemaFromSource(sources);
            return schema;
        }
        finally {
            for (InputStream is : streams) {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private static final Schema getSchemaFromSource(Source ... sources) throws JDOMException {
        if (sources == null) {
            throw new NullPointerException("Cannot specify a null input array");
        }
        if (sources.length == 0) {
            throw new IllegalArgumentException("You need at least one XSD Source for an XML Schema validator");
        }
        try {
            return schemafactl.get().newSchema(sources);
        }
        catch (SAXException e) {
            String msg = Arrays.toString(sources);
            throw new JDOMException("Unable to create a Schema for Sources " + msg, e);
        }
    }

    public XMLReaderXSDFactory(String ... systemid) throws JDOMException {
        super(XMLReaderXSDFactory.getSchemaFromString(systemid));
    }

    public XMLReaderXSDFactory(URL ... systemid) throws JDOMException {
        super(XMLReaderXSDFactory.getSchemaFromURL(systemid));
    }

    public XMLReaderXSDFactory(File ... systemid) throws JDOMException {
        super(XMLReaderXSDFactory.getSchemaFromFile(systemid));
    }

    public XMLReaderXSDFactory(Source ... sources) throws JDOMException {
        super(XMLReaderXSDFactory.getSchemaFromSource(sources));
    }
}

