/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jdom2.Content;
import org.jdom2.Parent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DescendantIterator
implements Iterator<Content> {
    private LinkedList<ListIterator<Content>> stack = new LinkedList();
    ListIterator<Content> current = null;
    ListIterator<Content> following = null;

    DescendantIterator(Parent parent) {
        this.current = parent.getContent().listIterator();
    }

    @Override
    public boolean hasNext() {
        if (this.following != null && this.following.hasNext()) {
            return true;
        }
        if (this.current.hasNext()) {
            return true;
        }
        for (ListIterator listIterator : this.stack) {
            if (!listIterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Content next() {
        Content ret = null;
        if (this.following != null && this.following.hasNext()) {
            ret = this.following.next();
            this.stack.addFirst(this.current);
            this.current = this.following;
        } else if (this.current.hasNext()) {
            ret = this.current.next();
        } else {
            while (ret == null && !this.stack.isEmpty()) {
                this.current = this.stack.removeFirst();
                if (!this.current.hasNext()) continue;
                ret = this.current.next();
            }
        }
        if (ret == null) {
            throw new NoSuchElementException("Iterated off the end of the DescendantIterator");
        }
        this.following = ret instanceof Parent ? ((Parent)((Object)ret)).getContent().listIterator() : null;
        return ret;
    }

    @Override
    public void remove() {
        this.current.remove();
        this.following = null;
    }
}

