/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.json;

import java.lang.reflect.Type;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.json.Json;
import org.jdbi.v3.json.JsonConfig;
import org.jdbi.v3.json.JsonMapper;
import org.jdbi.v3.json.JsonPlugin;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class JsonPluginTest {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new JsonPlugin());
    @Mock
    public JsonMapper jsonMapper;

    @BeforeEach
    public void before() {
        ((JsonConfig)this.h2Extension.getJdbi().getConfig(JsonConfig.class)).setJsonMapper(this.jsonMapper);
        this.h2Extension.getJdbi().useHandle(h -> h.createUpdate("create table foo(bar varchar)").execute());
    }

    @Test
    public void factoryChainWorks() {
        Foo instance = new Foo();
        String json = "foo";
        Mockito.when((Object)this.jsonMapper.toJson((Type)ArgumentMatchers.eq(Foo.class), ArgumentMatchers.eq((Object)instance), (ConfigRegistry)ArgumentMatchers.any(ConfigRegistry.class))).thenReturn((Object)json);
        Mockito.when((Object)this.jsonMapper.fromJson((Type)ArgumentMatchers.eq(Foo.class), (String)ArgumentMatchers.eq((Object)json), (ConfigRegistry)ArgumentMatchers.any(ConfigRegistry.class))).thenReturn((Object)instance);
        Object result = this.h2Extension.getJdbi().withHandle(h -> {
            ((Update)h.createUpdate("insert into foo(bar) values(:foo)").bindByType("foo", instance, QualifiedType.of(Foo.class).with(new Class[]{Json.class}))).execute();
            Assertions.assertThat((String)((String)h.createQuery("select bar from foo").mapTo(String.class).one())).isEqualTo(json);
            return (Foo)h.createQuery("select bar from foo").mapTo(QualifiedType.of(Foo.class).with(new Class[]{Json.class})).one();
        });
        Assertions.assertThat((Object)result).isSameAs((Object)instance);
        ((JsonMapper)Mockito.verify((Object)this.jsonMapper)).fromJson((Type)ArgumentMatchers.eq(Foo.class), (String)ArgumentMatchers.eq((Object)json), (ConfigRegistry)ArgumentMatchers.any(ConfigRegistry.class));
        ((JsonMapper)Mockito.verify((Object)this.jsonMapper)).toJson((Type)ArgumentMatchers.eq(Foo.class), ArgumentMatchers.eq((Object)instance), (ConfigRegistry)ArgumentMatchers.any(ConfigRegistry.class));
    }

    public static class Foo {
        public String toString() {
            return "I am Foot.";
        }
    }
}

