/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.json;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.mapper.reflect.ConstructorMapper;
import org.jdbi.v3.core.mapper.reflect.FieldMapper;
import org.jdbi.v3.json.Json;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.BindFields;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class AbstractIssue2395Test {
    Handle handle;

    protected abstract Handle getHandle();

    @BeforeEach
    void setUp() {
        this.handle = this.getHandle();
        this.handle.registerRowMapper(ConstructorWrapper.class, ConstructorMapper.of(ConstructorWrapper.class));
        this.handle.registerRowMapper(FieldWrapper.class, FieldMapper.of(FieldWrapper.class));
        this.handle.registerRowMapper(BeanWrapper.class, BeanMapper.of(BeanWrapper.class));
        this.handle.execute("create table test2395 (id integer not null primary key, name varchar(255), data json)", new Object[0]);
    }

    @Test
    @DisplayName(value="Test storing and retrieving a nested json field.")
    void testConstructorWrapperIssue2395() {
        ConstructorWrapper data1 = new ConstructorWrapper(1, "alice", Arrays.asList(new JsonData("first", "one", 4), new JsonData("second", "two", 8), new JsonData("third", "three", 15), new JsonData("fourth", "four", 16), new JsonData("fifth", "five", 23), new JsonData("sixth", "six", 42)));
        ConstructorWrapper data2 = new ConstructorWrapper(2, "bob", Collections.singletonList(new JsonData("toast", "words", 8)));
        CtorDao dao = (CtorDao)this.handle.attach(CtorDao.class);
        dao.write(data1);
        dao.write(data2);
        List<ConstructorWrapper> data = dao.readAll();
        Assertions.assertThat(data).containsExactly((Object[])new ConstructorWrapper[]{data1, data2});
        Assertions.assertThat((Object)dao.retrieve(1)).isEqualTo((Object)data1);
        Assertions.assertThat((Object)dao.retrieve(2)).isEqualTo((Object)data2);
    }

    @Test
    @DisplayName(value="Test storing and retrieving a nested json field.")
    void testFieldWrapperIssue2395() {
        FieldWrapper data1 = new FieldWrapper();
        data1.id = 1;
        data1.name = "alice";
        data1.data = Arrays.asList(new JsonData("first", "one", 4), new JsonData("second", "two", 8), new JsonData("third", "three", 15), new JsonData("fourth", "four", 16), new JsonData("fifth", "five", 23), new JsonData("sixth", "six", 42));
        FieldWrapper data2 = new FieldWrapper();
        data2.id = 2;
        data2.name = "bob";
        data2.data = Collections.singletonList(new JsonData("toast", "words", 8));
        FieldDao dao = (FieldDao)this.handle.attach(FieldDao.class);
        dao.write(data1);
        dao.write(data2);
        List<FieldWrapper> data = dao.readAll();
        Assertions.assertThat(data).containsExactly((Object[])new FieldWrapper[]{data1, data2});
        Assertions.assertThat((Object)dao.retrieve(1)).isEqualTo((Object)data1);
        Assertions.assertThat((Object)dao.retrieve(2)).isEqualTo((Object)data2);
    }

    @Test
    @DisplayName(value="Test storing and retrieving a nested json field.")
    void testBeanWrapperIssue2395() {
        BeanWrapper data1 = new BeanWrapper();
        data1.setId(1);
        data1.setName("alice");
        data1.setData(Arrays.asList(new JsonData("first", "one", 4), new JsonData("second", "two", 8), new JsonData("third", "three", 15), new JsonData("fourth", "four", 16), new JsonData("fifth", "five", 23), new JsonData("sixth", "six", 42)));
        BeanWrapper data2 = new BeanWrapper();
        data2.setId(2);
        data2.setName("bob");
        data2.setData(Collections.singletonList(new JsonData("toast", "words", 8)));
        BeanDao dao = (BeanDao)this.handle.attach(BeanDao.class);
        dao.write(data1);
        dao.write(data2);
        List<BeanWrapper> data = dao.readAll();
        Assertions.assertThat(data).containsExactly((Object[])new BeanWrapper[]{data1, data2});
        Assertions.assertThat((Object)dao.retrieve(1)).isEqualTo((Object)data1);
        Assertions.assertThat((Object)dao.retrieve(2)).isEqualTo((Object)data2);
    }

    public static class ConstructorWrapper {
        private final int id;
        private final String name;
        private final List<JsonData> data;

        public ConstructorWrapper(int id, String name, @Json List<JsonData> data) {
            this.id = id;
            this.name = name;
            this.data = data;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @Json
        public List<JsonData> getData() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstructorWrapper wrapper = (ConstructorWrapper)o;
            return this.id == wrapper.id && Objects.equals(this.name, wrapper.name) && Objects.equals(this.data, wrapper.data);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.data);
        }
    }

    public static class FieldWrapper {
        public int id;
        public String name;
        @Json
        public List<JsonData> data;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldWrapper wrapper = (FieldWrapper)o;
            return this.id == wrapper.id && Objects.equals(this.name, wrapper.name) && Objects.equals(this.data, wrapper.data);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.data);
        }
    }

    public static class BeanWrapper {
        private int id;
        private String name;
        private List<JsonData> data;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Json
        public List<JsonData> getData() {
            return this.data;
        }

        public void setData(List<JsonData> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeanWrapper wrapper = (BeanWrapper)o;
            return this.id == wrapper.id && Objects.equals(this.name, wrapper.name) && Objects.equals(this.data, wrapper.data);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.data);
        }
    }

    public static class JsonData {
        private final String key1;
        private final String key2;
        private final int key3;

        public JsonData(String key1, String key2, int key3) {
            this.key1 = key1;
            this.key2 = key2;
            this.key3 = key3;
        }

        public String getKey1() {
            return this.key1;
        }

        public String getKey2() {
            return this.key2;
        }

        public int getKey3() {
            return this.key3;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonData jsonData = (JsonData)o;
            return this.key3 == jsonData.key3 && Objects.equals(this.key1, jsonData.key1) && Objects.equals(this.key2, jsonData.key2);
        }

        public int hashCode() {
            return Objects.hash(this.key1, this.key2, this.key3);
        }
    }

    public static interface CtorDao {
        @SqlUpdate(value="insert into test2395 (id, name, data) values (:id, :name, :data)")
        public void write(@BindBean ConstructorWrapper var1);

        @SqlQuery(value="select * from test2395")
        public List<ConstructorWrapper> readAll();

        @SqlQuery(value="select * from test2395 where id = :id")
        public ConstructorWrapper retrieve(int var1);
    }

    public static interface FieldDao {
        @SqlUpdate(value="insert into test2395 (id, name, data) values (:id, :name, :data)")
        public void write(@BindFields FieldWrapper var1);

        @SqlQuery(value="select * from test2395")
        public List<FieldWrapper> readAll();

        @SqlQuery(value="select * from test2395 where id = :id")
        public FieldWrapper retrieve(int var1);
    }

    public static interface BeanDao {
        @SqlUpdate(value="insert into test2395 (id, name, data) values (:id, :name, :data)")
        public void write(@BindBean BeanWrapper var1);

        @SqlQuery(value="select * from test2395")
        public List<BeanWrapper> readAll();

        @SqlQuery(value="select * from test2395 where id = :id")
        public BeanWrapper retrieve(int var1);
    }
}

