/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jdbi.v3.meta.Beta;

@Beta
public final class Sql
implements CharSequence {
    private final String str;

    private Sql(String sql) {
        this.str = sql;
    }

    public static Sql of(CharSequence ... tokens) {
        return tokens == null ? new Sql("") : Sql.of(Arrays.asList(tokens));
    }

    public static Sql of(Collection<CharSequence> tokens) {
        return tokens == null ? new Sql("") : new Sql(Sql.format(tokens));
    }

    static String format(Collection<CharSequence> tokens) {
        String sql = Objects.requireNonNull(tokens).stream().filter(Objects::nonNull).map(CharSequence::toString).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.joining(" "));
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql;
    }

    @Override
    public int length() {
        return this.str.length();
    }

    @Override
    public char charAt(int index) {
        return this.str.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.str.subSequence(start, end);
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.str.equals(((Sql)obj).str);
    }

    @Override
    public String toString() {
        return this.str;
    }
}

