/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.config;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.net.URI;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageApi;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageAsyncApi;
import org.jclouds.hpcloud.objectstorage.extensions.CDNContainerApi;
import org.jclouds.hpcloud.objectstorage.extensions.CDNContainerAsyncApi;
import org.jclouds.hpcloud.services.HPExtensionCDN;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.config.SwiftRestClientModule;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.util.Suppliers2;

@ConfiguresRestClient
public class HPCloudObjectStorageRestClientModule
extends SwiftRestClientModule<HPCloudObjectStorageApi, HPCloudObjectStorageAsyncApi> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(CDNContainerApi.class, CDNContainerAsyncApi.class).build();

    public HPCloudObjectStorageRestClientModule() {
        super(TypeToken.of(HPCloudObjectStorageApi.class), TypeToken.of(HPCloudObjectStorageAsyncApi.class), DELEGATE_MAP);
    }

    protected void bindResolvedClientsToCommonSwift() {
        this.bind(CommonSwiftClient.class).to(HPCloudObjectStorageApi.class).in(Scopes.SINGLETON);
        this.bind(CommonSwiftAsyncClient.class).to(HPCloudObjectStorageAsyncApi.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @HPExtensionCDN
    protected Supplier<URI> provideCDNUrl(RegionIdToURISupplier.Factory factory, @ApiVersion String apiVersion) {
        return Suppliers2.getLastValueInMap((Supplier)factory.createForApiTypeAndVersion("hpext:cdn", apiVersion));
    }
}

