/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.inject.Provider;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageAsyncApi;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.options.GetOptions;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.rest.annotations.Credential;
import org.jclouds.rest.annotations.Identity;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;

@Singleton
public class HPCloudObjectStorageBlobRequestSigner
implements BlobRequestSigner {
    private final RestAnnotationProcessor<HPCloudObjectStorageAsyncApi> processor;
    private final Crypto crypto;
    private final Provider<Long> unixEpochTimestampProvider;
    private final Supplier<Access> access;
    private String tenantId;
    private final String accessKeyId;
    private final String secretKey;
    private final BlobToObject blobToObject;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final Method getMethod;
    private final Method deleteMethod;
    private final Method createMethod;

    @Inject
    public HPCloudObjectStorageBlobRequestSigner(RestAnnotationProcessor<HPCloudObjectStorageAsyncApi> processor, BlobToObject blobToObject, BlobToHttpGetOptions blob2HttpGetOptions, Crypto crypto, @TimeStamp Provider<Long> unixEpochTimestampProvider, Supplier<Access> access, @Identity String accessKey, @Credential String secretKey) throws SecurityException, NoSuchMethodException {
        this.processor = (RestAnnotationProcessor)Preconditions.checkNotNull(processor, (Object)"processor");
        this.crypto = (Crypto)Preconditions.checkNotNull((Object)crypto, (Object)"crypto");
        this.unixEpochTimestampProvider = (Provider)Preconditions.checkNotNull(unixEpochTimestampProvider, (Object)"unixEpochTimestampProvider");
        this.access = (Supplier)Preconditions.checkNotNull(access, (Object)"access");
        this.accessKeyId = accessKey.substring(accessKey.indexOf(58) + 1);
        this.secretKey = secretKey;
        this.blobToObject = (BlobToObject)Preconditions.checkNotNull((Object)blobToObject, (Object)"blobToObject");
        this.blob2HttpGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2HttpGetOptions, (Object)"blob2HttpGetOptions");
        this.getMethod = HPCloudObjectStorageAsyncApi.class.getMethod("getObject", String.class, String.class, GetOptions[].class);
        this.deleteMethod = HPCloudObjectStorageAsyncApi.class.getMethod("removeObject", String.class, String.class);
        this.createMethod = HPCloudObjectStorageAsyncApi.class.getMethod("putObject", String.class, SwiftObject.class);
    }

    @PostConstruct
    public void populateTenantId() {
        this.tenantId = ((Access)this.access.get()).getToken().getTenant().getId();
    }

    public HttpRequest signGetBlob(String container, String name) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.getMethod, new Object[]{container, name}));
    }

    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        GeneratedHttpRequest request = this.processor.createRequest(this.getMethod, new Object[]{container, name});
        return BlobStoreUtils.cleanRequest((HttpRequest)this.signForTemporaryAccess((HttpRequest)request, timeInSeconds));
    }

    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.getMethod, new Object[]{container, name, this.blob2HttpGetOptions.apply(options)}));
    }

    public HttpRequest signPutBlob(String container, Blob blob) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.createMethod, new Object[]{container, this.blobToObject.apply(blob)}));
    }

    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        GeneratedHttpRequest request = this.processor.createRequest(this.createMethod, new Object[]{container, this.blobToObject.apply(blob)});
        return BlobStoreUtils.cleanRequest((HttpRequest)this.signForTemporaryAccess((HttpRequest)request, timeInSeconds));
    }

    public HttpRequest signRemoveBlob(String container, String name) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.deleteMethod, new Object[]{container, name}));
    }

    private HttpRequest signForTemporaryAccess(HttpRequest request, long timeInSeconds) {
        HttpRequest.Builder builder = request.toBuilder();
        builder.filters(Iterables.filter((Iterable)request.getFilters(), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(AuthenticateRequest.class))));
        long expiresInSeconds = (Long)this.unixEpochTimestampProvider.get() + timeInSeconds;
        String signature = this.createSignature(this.secretKey, this.createStringToSign(request.getMethod().toUpperCase(), request, expiresInSeconds));
        builder.addQueryParam("temp_url_sig", new String[]{String.format("%s:%s:%s", this.tenantId, this.accessKeyId, signature)});
        builder.addQueryParam("temp_url_expires", new String[]{"" + expiresInSeconds});
        return builder.build();
    }

    private String createStringToSign(String method, HttpRequest request, long expiresInSeconds) {
        Preconditions.checkArgument((method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("PUT") ? 1 : 0) != 0);
        return String.format("%s\n%d\n%s", method.toUpperCase(), expiresInSeconds, request.getEndpoint().getPath());
    }

    private String createSignature(String key, String stringToSign) {
        try {
            return CryptoStreams.hex((byte[])this.crypto.hmacSHA1(key.getBytes()).doFinal(stringToSign.getBytes()));
        }
        catch (InvalidKeyException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

