/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.xml.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.fujitsu.fgcp.domain.PublicIP;
import org.jclouds.fujitsu.fgcp.xml.internal.MapWithStatusResponse;
import org.jclouds.fujitsu.fgcp.xml.internal.PublicIPWithSystemId;
import org.jclouds.fujitsu.fgcp.xml.internal.SingleElementResponse;

@XmlRootElement(name="ListPublicIPResponse")
public class ListPublicIPResponse
extends MapWithStatusResponse<PublicIP, String>
implements SingleElementResponse {
    @XmlElementWrapper(name="publicips")
    @XmlElement(name="publicip")
    private Set<PublicIPWithSystemId> ips;

    @Override
    public String toString() {
        return this.getElement().toString();
    }

    protected Map<PublicIP, String> delegate() {
        ImmutableMap.Builder returnVal = ImmutableMap.builder();
        if (this.ips != null) {
            for (PublicIPWithSystemId ip : this.ips) {
                returnVal.put((Object)ip, (Object)ip.getVsysId());
            }
        }
        return returnVal.build();
    }

    @Override
    public Set<? extends PublicIP> getElement() {
        return this.ips == null ? ImmutableSet.of() : Collections.unmodifiableSet(this.ips);
    }
}

