/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.xml;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;

public class BindParamsToXmlPayload
extends BindToStringPayload
implements MapBinder {
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> mapParams) {
        URI uriWithoutQueryParams;
        String action = Preconditions.checkNotNull((Object)mapParams.remove("Action"), (Object)"Action").toString();
        String version = Strings.nullToEmpty((String)((String)mapParams.remove("Version")));
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        xml.append("<OViSSRequest>\r\n");
        xml.append("  <Action>" + action + "</Action>\r\n");
        for (Map.Entry<String, Object> entry : mapParams.entrySet()) {
            String key = entry.getKey();
            xml.append("  <" + key + ">" + Preconditions.checkNotNull((Object)mapParams.get(key)) + "</" + key + ">\r\n");
        }
        xml.append("  <Version>" + version + "</Version>\r\n");
        xml.append("  <Locale></Locale>\r\n");
        xml.append("  <AccessKeyId></AccessKeyId>\r\n");
        xml.append("  <Signature></Signature>\r\n");
        xml.append("</OViSSRequest>");
        request = super.bindToRequest(request, (Object)xml);
        request.getPayload().getContentMetadata().setContentType("text/xml");
        URI uri = request.getEndpoint();
        try {
            uriWithoutQueryParams = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, uri.getFragment());
        }
        catch (URISyntaxException e) {
            uriWithoutQueryParams = uri;
        }
        return (R)request.toBuilder().endpoint(uriWithoutQueryParams).build();
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalArgumentException("BindParamsToXmlPayload needs bind parameters");
    }
}

