/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.concurrent.Timeout;
import org.jclouds.fujitsu.fgcp.binders.BindAlsoToSystemId;
import org.jclouds.fujitsu.fgcp.compute.functions.SingleElementResponseToElement;
import org.jclouds.fujitsu.fgcp.domain.BuiltinServer;
import org.jclouds.fujitsu.fgcp.domain.PublicIP;
import org.jclouds.fujitsu.fgcp.domain.VDisk;
import org.jclouds.fujitsu.fgcp.domain.VServer;
import org.jclouds.fujitsu.fgcp.domain.VSystem;
import org.jclouds.fujitsu.fgcp.domain.VSystemStatus;
import org.jclouds.fujitsu.fgcp.domain.VSystemWithDetails;
import org.jclouds.fujitsu.fgcp.filters.RequestAuthenticator;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.JAXBResponseParser;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;

@RequestFilters(value={RequestAuthenticator.class})
@QueryParams(keys={"Version"}, values={"2012-02-18"})
@PayloadParams(keys={"Version"}, values={"2012-02-18"})
@Consumes(value={"text/xml"})
@Timeout(duration=60L, timeUnit=TimeUnit.SECONDS)
public interface VirtualSystemAsyncApi {
    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"DestroyVSYS"})
    public ListenableFuture<Void> destroy(@QueryParam(value="vsysId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetVSYSStatus"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<VSystemStatus> getStatus(@QueryParam(value="vsysId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetVSYSAttributes"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<VSystem> get(@QueryParam(value="vsysId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetVSYSConfiguration"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<VSystemWithDetails> getDetails(@QueryParam(value="vsysId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"UpdateVSYSAttribute"})
    public ListenableFuture<Void> update(@QueryParam(value="vsysId") String var1, @QueryParam(value="attributeName") String var2, @QueryParam(value="attributeValue") String var3);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"UpdateVSYSConfiguration"})
    public ListenableFuture<Void> updateConfiguration(@QueryParam(value="vsysId") String var1, @QueryParam(value="configurationName") String var2, @QueryParam(value="configurationValue") String var3);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"CreateVServer"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<String> createServer(@QueryParam(value="vserverName") String var1, @QueryParam(value="vserverType") String var2, @QueryParam(value="diskImageId") String var3, @BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="networkId") String var4);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"ListVServer"})
    public ListenableFuture<Set<VServer>> listServers(@QueryParam(value="vsysId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"CreateVDisk"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<String> createDisk(@QueryParam(value="vsysId") String var1, @QueryParam(value="vdiskName") String var2, @QueryParam(value="size") int var3);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"ListVDisk"})
    public ListenableFuture<Set<VDisk>> listDisks(@QueryParam(value="vsysId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"AllocatePublicIP"})
    public ListenableFuture<Void> allocatePublicIP(@QueryParam(value="vsysId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"ListPublicIP"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<Set<PublicIP>> listPublicIPs(@QueryParam(value="vsysId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action", "efmType"}, values={"CreateEFM", "SLB"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<String> createBuiltinServer(@QueryParam(value="efmName") String var1, @BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="networkId") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"ListEFM"})
    public ListenableFuture<Set<BuiltinServer>> listBuiltinServers(@QueryParam(value="vsysId") String var1, @QueryParam(value="efmType") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"StandByConsole"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<String> standByConsole(@QueryParam(value="vsysId") String var1, @QueryParam(value="networkId") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"RegisterPrivateVSYSDescriptor"})
    public ListenableFuture<Void> registerAsPrivateVSYSDescriptor(@QueryParam(value="vsysId") String var1, @QueryParam(value="vsysDescriptorXMLFilePath") String var2);
}

