/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.QueryParam;
import org.jclouds.concurrent.Timeout;
import org.jclouds.fujitsu.fgcp.binders.BindAlsoToSystemId;
import org.jclouds.fujitsu.fgcp.compute.functions.SingleElementResponseToElement;
import org.jclouds.fujitsu.fgcp.domain.PerformanceInfo;
import org.jclouds.fujitsu.fgcp.domain.VServer;
import org.jclouds.fujitsu.fgcp.domain.VServerStatus;
import org.jclouds.fujitsu.fgcp.domain.VServerWithDetails;
import org.jclouds.fujitsu.fgcp.filters.RequestAuthenticator;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.JAXBResponseParser;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;

@RequestFilters(value={RequestAuthenticator.class})
@QueryParams(keys={"Version"}, values={"2012-02-18"})
@PayloadParams(keys={"Version"}, values={"2012-02-18"})
@Consumes(value={"text/xml"})
@Timeout(duration=60L, timeUnit=TimeUnit.SECONDS)
public interface VirtualServerAsyncApi {
    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"StartVServer"})
    public ListenableFuture<Void> start(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vserverId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"StopVServer"})
    public ListenableFuture<Void> stop(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vserverId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action", "force"}, values={"StopVServer", "true"})
    public ListenableFuture<Void> stopForcefully(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vserverId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"DestroyVServer"})
    public ListenableFuture<Void> destroy(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vserverId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetVServerAttributes"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<VServer> get(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vserverId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetVServerConfiguration"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<VServerWithDetails> getDetails(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vserverId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"UpdateVServerAttribute"})
    public ListenableFuture<Void> update(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vserverId") String var1, @QueryParam(value="attributeName") String var2, @QueryParam(value="attributeValue") String var3);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetVServerStatus"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<VServerStatus> getStatus(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vserverId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetVServerInitialPassword"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<String> getInitialPassword(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vserverId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"AttachVDisk"})
    public ListenableFuture<Void> attachDisk(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vserverId") String var1, @QueryParam(value="vdiskId") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetPerformanceInformation"})
    public ListenableFuture<Set<PerformanceInfo>> getPerformanceInformation(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="serverId") String var1, @QueryParam(value="interval") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetPerformanceInformation"})
    public ListenableFuture<Set<PerformanceInfo>> getPerformanceInformation(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="serverId") String var1, @QueryParam(value="dataType") String var2, @QueryParam(value="interval") String var3);

    @POST
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"RegisterPrivateDiskImage"})
    public ListenableFuture<Void> registerAsPrivateDiskImage(String var1);
}

