/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.concurrent.Timeout;
import org.jclouds.fujitsu.fgcp.compute.functions.SingleElementResponseToElement;
import org.jclouds.fujitsu.fgcp.domain.AddressRange;
import org.jclouds.fujitsu.fgcp.domain.DiskImage;
import org.jclouds.fujitsu.fgcp.domain.EventLog;
import org.jclouds.fujitsu.fgcp.domain.Information;
import org.jclouds.fujitsu.fgcp.domain.PublicIP;
import org.jclouds.fujitsu.fgcp.domain.ServerType;
import org.jclouds.fujitsu.fgcp.domain.UsageInfo;
import org.jclouds.fujitsu.fgcp.domain.VSystem;
import org.jclouds.fujitsu.fgcp.domain.VSystemDescriptor;
import org.jclouds.fujitsu.fgcp.filters.RequestAuthenticator;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.JAXBResponseParser;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;

@RequestFilters(value={RequestAuthenticator.class})
@QueryParams(keys={"Version"}, values={"2012-02-18"})
@PayloadParams(keys={"Version"}, values={"2012-02-18"})
@Consumes(value={"text/xml"})
@Timeout(duration=60L, timeUnit=TimeUnit.SECONDS)
public interface VirtualDCAsyncApi {
    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"CreateVSYS"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<String> createVirtualSystem(@QueryParam(value="vsysDescriptorId") String var1, @QueryParam(value="vsysName") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"ListVSYS"})
    public ListenableFuture<Set<VSystem>> listVirtualSystems();

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action", "diskImageId"}, values={"ListServerType", "dummy"})
    public ListenableFuture<Set<ServerType>> listServerTypes();

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"ListDiskImage"})
    public ListenableFuture<Set<DiskImage>> listDiskImages();

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"ListDiskImage"})
    public ListenableFuture<Set<DiskImage>> listDiskImages(@Nullable @QueryParam(value="serverCategory") String var1, @QueryParam(value="vsysDescriptorId") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"ListPublicIP"})
    public ListenableFuture<Map<PublicIP, String>> listPublicIPs();

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"AddAddressRange"})
    public ListenableFuture<Void> addAddressRange(@QueryParam(value="pipFrom") String var1, @QueryParam(value="pipTo") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"CreateAddressPool"})
    public ListenableFuture<Void> createAddressPool(@QueryParam(value="pipFrom") String var1, @QueryParam(value="pipTo") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"DeleteAddressRange"})
    public ListenableFuture<Void> deleteAddressRange(@QueryParam(value="pipFrom") String var1, @QueryParam(value="pipTo") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetAddressRange"})
    public ListenableFuture<Set<AddressRange>> getAddressRange();

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"ListVSYSDescriptor"})
    public ListenableFuture<Set<VSystemDescriptor>> listVSYSDescriptor();

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"ListVSYSDescriptor"})
    public ListenableFuture<Set<VSystemDescriptor>> listVSYSDescriptor(@QueryParam(value="keyword") String var1, @QueryParam(value="estimateFrom") int var2, @QueryParam(value="estimateTo") int var3);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetEventLog"})
    public ListenableFuture<Set<EventLog>> getEventLogs();

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetEventLog"})
    public ListenableFuture<Set<EventLog>> getEventLogs(@QueryParam(value="all") boolean var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetInformation"})
    public ListenableFuture<Set<Information>> getInformation();

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetInformation"})
    public ListenableFuture<Set<Information>> getInformation(@QueryParam(value="all") boolean var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetSystemUsage"})
    public ListenableFuture<Set<UsageInfo>> getSystemUsage();

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetSystemUsage"})
    public ListenableFuture<Set<UsageInfo>> getSystemUsage(@QueryParam(value="systemIds") String var1);
}

