/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.concurrent.Timeout;
import org.jclouds.fujitsu.fgcp.compute.functions.SingleElementResponseToElement;
import org.jclouds.fujitsu.fgcp.domain.PublicIP;
import org.jclouds.fujitsu.fgcp.domain.PublicIPStatus;
import org.jclouds.fujitsu.fgcp.filters.RequestAuthenticator;
import org.jclouds.rest.annotations.JAXBResponseParser;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;

@RequestFilters(value={RequestAuthenticator.class})
@QueryParams(keys={"Version"}, values={"2012-02-18"})
@PayloadParams(keys={"Version"}, values={"2012-02-18"})
@Consumes(value={"text/xml"})
@Timeout(duration=60L, timeUnit=TimeUnit.SECONDS)
public interface PublicIPAddressAsyncApi {
    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"AttachPublicIP"})
    public ListenableFuture<Void> attach(@QueryParam(value="vsysId") String var1, @QueryParam(value="publicIp") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"DetachPublicIP"})
    public ListenableFuture<Void> detach(@QueryParam(value="vsysId") String var1, @QueryParam(value="publicIp") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetPublicIPStatus"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<PublicIPStatus> getStatus(@QueryParam(value="publicIp") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetPublicIPAttributes"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<PublicIP> get(@QueryParam(value="publicIp") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"FreePublicIP"})
    public ListenableFuture<Void> free(@QueryParam(value="vsysId") String var1, @QueryParam(value="publicIp") String var2);
}

