/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.concurrent.Timeout;
import org.jclouds.fujitsu.fgcp.binders.BindAlsoToSystemId;
import org.jclouds.fujitsu.fgcp.compute.functions.SingleElementResponseToElement;
import org.jclouds.fujitsu.fgcp.domain.BuiltinServer;
import org.jclouds.fujitsu.fgcp.domain.BuiltinServerBackup;
import org.jclouds.fujitsu.fgcp.domain.BuiltinServerConfiguration;
import org.jclouds.fujitsu.fgcp.domain.BuiltinServerStatus;
import org.jclouds.fujitsu.fgcp.filters.RequestAuthenticator;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.JAXBResponseParser;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;

@RequestFilters(value={RequestAuthenticator.class})
@QueryParams(keys={"Version"}, values={"2012-02-18"})
@PayloadParams(keys={"Version"}, values={"2012-02-18"})
@Consumes(value={"text/xml"})
@Timeout(duration=60L, timeUnit=TimeUnit.SECONDS)
public interface BuiltinServerAsyncApi {
    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"StartEFM"})
    public ListenableFuture<Void> start(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="efmId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"StopEFM"})
    public ListenableFuture<Void> stop(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="efmId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"DestroyEFM"})
    public ListenableFuture<Void> destroy(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="efmId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"BackupEFM"})
    public ListenableFuture<Void> backup(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="efmId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"RestoreEFM"})
    public ListenableFuture<Void> restore(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="efmId") String var1, @QueryParam(value="backupId") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"ListEFMBackup"})
    public ListenableFuture<Set<BuiltinServerBackup>> listBackups(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="efmId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"DestroyEFMBackup"})
    public ListenableFuture<Void> destroyBackup(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="efmId") String var1, @QueryParam(value="backupId") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetEFMAttributes"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<BuiltinServer> get(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="efmId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"UpdateEFMAttribute"})
    public ListenableFuture<Void> update(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="efmId") String var1, @QueryParam(value="attributeName") String var2, @QueryParam(value="attributeValue") String var3);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetEFMStatus"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<BuiltinServerStatus> getStatus(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="efmId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetEFMConfiguration"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<BuiltinServer> getConfiguration(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="efmId") String var1, @QueryParam(value="configurationName") BuiltinServerConfiguration var2);
}

