/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.concurrent.Timeout;
import org.jclouds.fujitsu.fgcp.binders.BindAlsoToSystemId;
import org.jclouds.fujitsu.fgcp.compute.functions.SingleElementResponseToElement;
import org.jclouds.fujitsu.fgcp.domain.VDisk;
import org.jclouds.fujitsu.fgcp.domain.VDiskStatus;
import org.jclouds.fujitsu.fgcp.filters.RequestAuthenticator;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.JAXBResponseParser;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;

@RequestFilters(value={RequestAuthenticator.class})
@QueryParams(keys={"Version"}, values={"2012-02-18"})
@PayloadParams(keys={"Version"}, values={"2012-02-18"})
@Consumes(value={"text/xml"})
@Timeout(duration=60L, timeUnit=TimeUnit.SECONDS)
public interface AdditionalDiskAsyncApi {
    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetVDiskStatus"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<VDiskStatus> getStatus(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vdiskId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"GetVDiskAttributes"})
    @Transform(value=SingleElementResponseToElement.class)
    public ListenableFuture<VDisk> get(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vdiskId") String var1);

    @GET
    @QueryParams(keys={"Action"}, values={"UpdateVDiskAttribute"})
    public ListenableFuture<Void> update(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vdiskId") String var1, @QueryParam(value="attributeName") String var2, @QueryParam(value="attributeValue") String var3);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"BackupVDisk"})
    public ListenableFuture<Void> backup(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vdiskId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"RestoreVDisk"})
    public ListenableFuture<Void> restore(@QueryParam(value="vsysId") String var1, @QueryParam(value="backupId") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"DestroyVDisk"})
    public ListenableFuture<Void> destroy(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vdiskId") String var1);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"DetachVDisk"})
    public ListenableFuture<Void> detach(@BinderParam(value=BindAlsoToSystemId.class) @QueryParam(value="vdiskId") String var1, @QueryParam(value="vserverId") String var2);

    @GET
    @JAXBResponseParser
    @QueryParams(keys={"Action"}, values={"DestroyVDiskBackup"})
    public ListenableFuture<Void> destroyBackup(@QueryParam(value="vsysId") String var1, @QueryParam(value="backupId") String var2);
}

