/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.location;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.fujitsu.fgcp.FGCPAsyncApi;
import org.jclouds.fujitsu.fgcp.domain.VNet;
import org.jclouds.fujitsu.fgcp.domain.VSystem;
import org.jclouds.fujitsu.fgcp.domain.VSystemWithDetails;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.location.suppliers.all.RegionToProviderOrJustProvider;

@Singleton
public class SystemAndNetworkSegmentToLocationSupplier
implements LocationsSupplier {
    private final RegionToProviderOrJustProvider regionProvider;
    private FGCPAsyncApi api;

    @Inject
    SystemAndNetworkSegmentToLocationSupplier(RegionToProviderOrJustProvider regionProvider, FGCPAsyncApi api) {
        this.regionProvider = (RegionToProviderOrJustProvider)Preconditions.checkNotNull((Object)regionProvider, (Object)"regionToProviderOrJustProvider");
        this.api = (FGCPAsyncApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    public Set<Location> get() {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        try {
            ArrayList<ListenableFuture<VSystemWithDetails>> futures = new ArrayList<ListenableFuture<VSystemWithDetails>>();
            for (VSystem system : (Set)this.api.getVirtualDCApi().listVirtualSystems().get()) {
                futures.add(this.api.getVirtualSystemApi().getDetails(system.getId()));
            }
            for (VSystem system : (List)Futures.successfulAsList(futures).get()) {
                Location systemLocation = new LocationBuilder().scope(LocationScope.SYSTEM).parent((Location)Iterables.getOnlyElement((Iterable)this.regionProvider.get())).description(system.getName()).id(system.getId()).build();
                for (VNet net : ((VSystemWithDetails)system).getNetworks()) {
                    locations.add((Object)new LocationBuilder().scope(LocationScope.NETWORK).parent(systemLocation).description(net.getNetworkId().replaceFirst(".+(DMZ|SECURE.)", "\\1")).id(net.getNetworkId()).build());
                }
            }
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return locations.build();
    }
}

