/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.http;

import com.google.common.base.Supplier;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.config.SSLModule;
import org.jclouds.rest.annotations.Credential;

@Singleton
public class SSLContextWithKeysSupplier
implements Supplier<SSLContext> {
    private SSLContext sc;

    @Inject
    SSLContextWithKeysSupplier(KeyStore keyStore, @Credential String keyStorePassword, HttpUtils utils, SSLModule.TrustAllCerts trustAllCerts) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        TrustManager[] trustManager = null;
        if (utils.trustAllCerts()) {
            trustManager = new TrustManager[]{trustAllCerts};
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, keyStorePassword.toCharArray());
        this.sc = SSLContext.getInstance("TLS");
        this.sc.init(kmf.getKeyManagers(), trustManager, new SecureRandom());
    }

    public SSLContext get() {
        return this.sc;
    }
}

